/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class MvRequest
extends AbstractXrootdRequest {
    private String sourcePath;
    private String targetPath;
    private String opaque;

    public MvRequest(ByteBuf buffer) {
        super(buffer, 3009);
        int dlen = buffer.getInt(20);
        int end = 24 + dlen;
        int psep = buffer.indexOf(24, end, (byte)32);
        int osep = buffer.indexOf(psep, end, (byte)63);
        if (psep == -1) {
            throw new IllegalArgumentException("kXR_mv needs two paths!");
        }
        if (osep > -1) {
            this.sourcePath = buffer.toString(24, psep - 24, StandardCharsets.US_ASCII);
            this.targetPath = buffer.toString(psep + 1, osep - (psep + 1), StandardCharsets.US_ASCII);
            this.opaque = buffer.toString(osep + 1, end - (osep + 1), StandardCharsets.US_ASCII);
        } else {
            this.sourcePath = buffer.toString(24, psep - 24, StandardCharsets.US_ASCII);
            this.targetPath = buffer.toString(psep + 1, end - (psep + 1), StandardCharsets.US_ASCII);
            this.opaque = null;
        }
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String toString() {
        return "mv[" + this.getSourcePath() + "," + this.getTargetPath() + "," + this.getOpaque() + "]";
    }
}

