/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.protocol.messages.PathRequest;

public class OpenRequest
extends PathRequest {
    private final int mode;
    private final int options;

    public OpenRequest(ByteBuf buffer) {
        super(buffer, 3010);
        this.mode = buffer.getUnsignedShort(4);
        this.options = buffer.getUnsignedShort(6);
    }

    public int getUMask() {
        return this.mode;
    }

    public int getOptions() {
        return this.options;
    }

    public boolean isAsync() {
        return (this.getOptions() & 0x40) == 64;
    }

    public boolean isCompress() {
        return (this.getOptions() & 1) == 1;
    }

    public boolean isDelete() {
        return (this.getOptions() & 2) == 2;
    }

    public boolean isForce() {
        return (this.getOptions() & 4) == 4;
    }

    public boolean isNew() {
        return (this.getOptions() & 8) == 8;
    }

    public boolean isReadOnly() {
        return (this.getOptions() & 0x10) == 16;
    }

    public boolean isReadWrite() {
        return (this.getOptions() & 0x20) == 32;
    }

    public boolean isRefresh() {
        return (this.getOptions() & 0x80) == 128;
    }

    public boolean isRetStat() {
        return (this.getOptions() & 0x400) == 1024;
    }

    public boolean isMkPath() {
        return (this.getOptions() & 0x100) == 256;
    }

    public String toString() {
        return String.format("open[%d,%d,%s,%s]", this.getUMask(), this.getOptions(), this.getPath(), this.getOpaque());
    }
}

