/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class WriteRequest
extends AbstractXrootdRequest
implements ReferenceCounted {
    private final int fhandle;
    private final long offset;
    private final int dlen;
    private final ByteBuf data;

    public WriteRequest(ByteBuf buffer) {
        super(buffer, 3019);
        this.fhandle = buffer.getInt(4);
        this.offset = buffer.getLong(8);
        this.dlen = buffer.getInt(20);
        this.data = buffer.alloc().ioBuffer(this.dlen);
        buffer.getBytes(24, this.data);
    }

    public int getFileHandle() {
        return this.fhandle;
    }

    public long getWriteOffset() {
        return this.offset;
    }

    public int getDataLength() {
        return this.dlen;
    }

    public void getData(GatheringByteChannel out) throws IOException {
        int written;
        int index = 0;
        for (int len = this.dlen; len > 0; len -= written) {
            written = this.data.getBytes(index, out, len);
            index += written;
        }
    }

    public ByteBuffer[] toByteBuffers() {
        return (this.data.nioBufferCount() == -1 ? this.data.copy() : this.data).nioBuffers();
    }

    public String toString() {
        return String.format("write[handle=%d,offset=%d,length=%d]", this.fhandle, this.offset, this.dlen);
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int decrement) {
        return this.data.release(decrement);
    }

    public WriteRequest retain(int increment) {
        this.data.retain(increment);
        return this;
    }

    public WriteRequest retain() {
        this.data.retain();
        return this;
    }
}

