/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.stream.AbstractChunkedReadvResponse;

public class ChunkedFileReadvResponse
extends AbstractChunkedReadvResponse {
    private final List<RandomAccessFile> files;

    public ChunkedFileReadvResponse(ReadVRequest request, int maxFrameSize, List<RandomAccessFile> files) {
        super(request, maxFrameSize);
        this.files = files;
    }

    @Override
    protected long getSize(int fd) throws IOException, XrootdException {
        if (fd < 0 || fd >= this.files.size() || this.files.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
        return this.files.get(fd).length();
    }

    @Override
    protected ByteBuf read(ByteBufAllocator alloc, int fd, long position, int length) throws IOException, XrootdException {
        int bytes;
        if (fd < 0 || fd >= this.files.size() || this.files.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
        FileChannel channel = this.files.get(fd).getChannel();
        ByteBuf chunk = alloc.ioBuffer(length);
        chunk.writerIndex(length);
        ByteBuffer buffer = chunk.nioBuffer();
        while (length > 0 && (bytes = channel.read(buffer, position)) >= 0) {
            position += (long)bytes;
            length -= bytes;
        }
        chunk.writerIndex(chunk.writerIndex() - length);
        return chunk;
    }
}

