/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.dcache.xrootd.stream.ChunkedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedResponseWriteHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedResponseWriteHandler.class);
    private final Queue<PendingWrite> queue = new ArrayDeque<PendingWrite>();
    private PendingWrite currentWrite;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ChunkedResponse) {
            this.queue.add(new PendingWrite((ChunkedResponse)msg, promise));
        } else {
            ctx.write(msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.queue.isEmpty()) {
            ctx.flush();
        } else {
            Channel channel = ctx.channel();
            if (channel.isWritable() || !channel.isActive()) {
                this.doFlush(ctx);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
        super.channelInactive(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    private void discard(Throwable cause) {
        while (true) {
            PendingWrite currentWrite = this.currentWrite;
            if (this.currentWrite == null) {
                currentWrite = this.queue.poll();
            } else {
                this.currentWrite = null;
            }
            if (currentWrite == null) break;
            ChunkedResponse in = currentWrite.msg;
            try {
                if (!in.isEndOfInput()) {
                    if (cause == null) {
                        cause = new ClosedChannelException();
                    }
                    currentWrite.fail(cause);
                    continue;
                }
                currentWrite.success();
            }
            catch (Exception e) {
                currentWrite.fail(e);
                logger.warn(ChunkedResponse.class.getSimpleName() + ".isEndOfInput() failed", (Throwable)e);
            }
        }
    }

    private void doFlush(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return;
        }
        while (channel.isWritable()) {
            boolean endOfInput;
            if (this.currentWrite == null) {
                this.currentWrite = this.queue.poll();
            }
            if (this.currentWrite == null) break;
            final PendingWrite currentWrite = this.currentWrite;
            ChunkedResponse pendingMessage = currentWrite.msg;
            ByteBuf message = null;
            try {
                message = pendingMessage.nextChunk(ctx.alloc());
                endOfInput = pendingMessage.isEndOfInput();
            }
            catch (Throwable t) {
                this.currentWrite = null;
                if (message != null) {
                    ReferenceCountUtil.release(message);
                }
                currentWrite.fail(t);
                break;
            }
            if (message == null) {
                message = Unpooled.EMPTY_BUFFER;
            }
            final int amount = ChunkedResponseWriteHandler.amount(message);
            ChannelFuture f = ctx.write((Object)message);
            if (endOfInput) {
                this.currentWrite = null;
                f.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            currentWrite.fail(future.cause());
                        } else {
                            currentWrite.progress(amount);
                            currentWrite.success();
                        }
                    }
                });
            } else {
                f.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            currentWrite.fail(future.cause());
                        } else {
                            currentWrite.progress(amount);
                        }
                    }
                });
            }
            ctx.flush();
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            return;
        }
    }

    private static int amount(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return 1;
    }

    private static final class PendingWrite {
        final ChunkedResponse msg;
        final ChannelPromise promise;
        private long progress;

        PendingWrite(ChunkedResponse msg, ChannelPromise promise) {
            this.msg = msg;
            this.promise = promise;
        }

        void closeInput() {
            block2: {
                try {
                    this.msg.close();
                }
                catch (Throwable t) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn("Failed to close a chunked input.", t);
                }
            }
            ReferenceCountUtil.release((Object)this.msg);
        }

        void fail(Throwable cause) {
            this.closeInput();
            this.promise.tryFailure(cause);
        }

        void success() {
            this.closeInput();
            if (this.promise.isDone()) {
                return;
            }
            if (this.promise instanceof ChannelProgressivePromise) {
                ((ChannelProgressivePromise)this.promise).tryProgress(this.progress, this.progress);
            }
            this.promise.trySuccess();
        }

        void progress(int amount) {
            this.progress += (long)amount;
            if (this.promise instanceof ChannelProgressivePromise) {
                ((ChannelProgressivePromise)this.promise).tryProgress(this.progress, -1L);
            }
        }
    }
}

