/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.HandshakeRequest;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.UnknownRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdDecoder
extends ByteToMessageDecoder {
    private static final Logger _logger = LoggerFactory.getLogger(XrootdDecoder.class);
    private boolean gotHandshake = false;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int readable = in.readableBytes();
        if (!this.gotHandshake) {
            if (readable < 20) {
                return;
            }
            this.gotHandshake = true;
            out.add(new HandshakeRequest(in.readSlice(20)));
            return;
        }
        if (readable < 24) {
            return;
        }
        int pos = in.readerIndex();
        int headerFrameLength = in.getInt(pos + 20);
        if (headerFrameLength < 0) {
            _logger.error("Received illegal frame length in xrootd header: {}. Closing channel.", (Object)headerFrameLength);
            ctx.channel().close();
            return;
        }
        int length = 24 + headerFrameLength;
        if (readable < length) {
            return;
        }
        ByteBuf frame = in.readSlice(length);
        int requestID = frame.getUnsignedShort(2);
        switch (requestID) {
            case 3007: {
                out.add(new LoginRequest(frame));
                break;
            }
            case 3021: {
                out.add(new PrepareRequest(frame));
                break;
            }
            case 3010: {
                out.add(new OpenRequest(frame));
                break;
            }
            case 3017: {
                out.add(new StatRequest(frame));
                break;
            }
            case 3022: {
                out.add(new StatxRequest(frame));
                break;
            }
            case 3013: {
                out.add(new ReadRequest(frame));
                break;
            }
            case 3025: {
                out.add(new ReadVRequest(frame));
                break;
            }
            case 3019: {
                out.add(new WriteRequest(frame));
                break;
            }
            case 3016: {
                out.add(new SyncRequest(frame));
                break;
            }
            case 3003: {
                out.add(new CloseRequest(frame));
                break;
            }
            case 3006: {
                out.add(new ProtocolRequest(frame));
                break;
            }
            case 3014: {
                out.add(new RmRequest(frame));
                break;
            }
            case 3015: {
                out.add(new RmDirRequest(frame));
                break;
            }
            case 3008: {
                out.add(new MkDirRequest(frame));
                break;
            }
            case 3009: {
                out.add(new MvRequest(frame));
                break;
            }
            case 3004: {
                out.add(new DirListRequest(frame));
                break;
            }
            case 3000: {
                out.add(new AuthenticationRequest(frame));
                break;
            }
            case 3023: {
                out.add(new EndSessionRequest(frame));
                break;
            }
            case 3027: {
                out.add(new LocateRequest(frame));
                break;
            }
            case 3001: {
                out.add(new QueryRequest(frame));
                break;
            }
            case 3018: {
                out.add(new SetRequest(frame));
                break;
            }
            default: {
                out.add(new UnknownRequest(frame));
            }
        }
    }
}

