/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;

public class AsyncResponse<T extends XrootdRequest>
extends AbstractReferenceCounted
implements XrootdResponse<T> {
    private final XrootdResponse<T> response;

    public AsyncResponse(XrootdResponse<T> response) {
        this.response = response;
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    public XrootdResponse<T> getResponse() {
        return this.response;
    }

    @Override
    public T getRequest() {
        return this.response.getRequest();
    }

    @Override
    public int getDataLength() {
        return 16 + this.response.getDataLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ChannelHandlerContext ctx, final ChannelPromise promise) {
        try {
            int dlen = this.getDataLength();
            ByteBuf header = ctx.alloc().buffer(8 + dlen);
            try {
                header.writeShort(0);
                header.writeShort(4001);
                header.writeInt(dlen);
                header.writeInt(5008);
                header.writeInt(0);
            }
            catch (Error | RuntimeException t) {
                promise.setFailure(t);
                header.release();
                this.release();
                return;
            }
            ctx.write((Object)header).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        promise.tryFailure(future.cause());
                    }
                }
            });
            ChannelPromise channelPromise = ctx.newPromise();
            channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        promise.trySuccess();
                    } else {
                        promise.tryFailure(future.cause());
                    }
                }
            });
            ((XrootdResponse)ReferenceCountUtil.retain(this.response)).writeTo(ctx, channelPromise);
        }
        finally {
            this.release();
        }
    }

    protected void deallocate() {
        ReferenceCountUtil.release(this.response);
    }
}

