/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.DirListRequest;

public class DirListResponse
extends AbstractXrootdResponse<DirListRequest> {
    private final Iterable<String> names;

    public DirListResponse(DirListRequest request, int statusCode, Iterable<String> names) {
        super(request, statusCode);
        this.names = names;
    }

    public DirListResponse(DirListRequest request, Iterable<String> names) {
        this(request, 0, names);
    }

    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public int getDataLength() {
        int length = 0;
        for (String name : this.names) {
            length += name.length() + 1;
        }
        return length;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        Iterator<String> i = this.names.iterator();
        if (i.hasNext()) {
            buffer.writeBytes(i.next().getBytes(StandardCharsets.US_ASCII));
            while (i.hasNext()) {
                buffer.writeByte(10);
                buffer.writeBytes(i.next().getBytes(StandardCharsets.US_ASCII));
            }
            if (this.stat == 4000) {
                buffer.writeByte(10);
            } else {
                buffer.writeByte(0);
            }
        }
    }
}

