/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.HandshakeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger _log = LoggerFactory.getLogger(XrootdHandshakeHandler.class);
    private final int _serverType;

    public XrootdHandshakeHandler(int serverType) {
        this._serverType = serverType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            byte[] response;
            if (!(msg instanceof HandshakeRequest)) {
                _log.error("Invalid handshake");
                ctx.close();
                return;
            }
            byte[] request = ((HandshakeRequest)msg).getHandshake();
            if (!Arrays.equals(request, XrootdProtocol.HANDSHAKE_REQUEST)) {
                _log.error("Received corrupt handshake message ({} bytes).", (Object)request.length);
                ctx.close();
                return;
            }
            switch (this._serverType) {
                case 0: {
                    response = XrootdProtocol.HANDSHAKE_RESPONSE_LOADBALANCER;
                    break;
                }
                case 1: {
                    response = XrootdProtocol.HANDSHAKE_RESPONSE_DATASERVER;
                    break;
                }
                default: {
                    _log.error("Unknown server type ({})", (Object)this._serverType);
                    ctx.close();
                    return;
                }
            }
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])response));
            ctx.channel().pipeline().remove((ChannelHandler)this);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }
}

