/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class StringBucket
extends XrootdBucket {
    private final String _data;

    public StringBucket(XrootdSecurityProtocol.BucketType type, String data) {
        super(type);
        this._data = data;
    }

    public String getContent() {
        return this._data;
    }

    public static StringBucket deserialize(XrootdSecurityProtocol.BucketType type, ByteBuf buffer) {
        String s = buffer.toString(StandardCharsets.US_ASCII);
        return new StringBucket(type, s);
    }

    @Override
    public void serialize(ByteBuf out) {
        super.serialize(out);
        out.writeInt(this._data.length());
        out.writeBytes(this._data.getBytes());
    }

    @Override
    public int getSize() {
        return super.getSize() + 4 + this._data.getBytes().length;
    }

    @Override
    public String toString() {
        return super.toString() + this._data;
    }
}

