/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.CharMatcher;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class QueryRequest
extends AbstractXrootdRequest {
    public static final CharMatcher NULL_CHARACTER = CharMatcher.is((char)'\u0000');
    private final int reqcode;
    private final int fhandle;
    private String args;

    public QueryRequest(ByteBuf buffer) {
        super(buffer, 3001);
        this.reqcode = buffer.getUnsignedShort(4);
        this.fhandle = buffer.getInt(8);
        int alen = buffer.getInt(20);
        this.args = NULL_CHARACTER.trimTrailingFrom((CharSequence)buffer.toString(24, alen, StandardCharsets.US_ASCII));
    }

    public int getReqcode() {
        return this.reqcode;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String toString() {
        return String.format("query[%d,%d,%s]", this.reqcode, this.fhandle, this.args);
    }
}

