/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;

public abstract class AbstractXrootdResponse<T extends XrootdRequest>
implements XrootdResponse<T> {
    protected final T request;
    protected final int stat;

    public AbstractXrootdResponse(T request, int stat) {
        this.request = (XrootdRequest)Preconditions.checkNotNull(request);
        this.stat = stat;
    }

    @Override
    public T getRequest() {
        return this.request;
    }

    @Override
    public int getStatus() {
        return this.stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        int dlen = this.getDataLength();
        ByteBuf buffer = ctx.alloc().buffer(8 + dlen);
        try {
            buffer.writeShort(this.request.getStreamId());
            buffer.writeShort(this.stat);
            buffer.writeInt(dlen);
            this.getBytes(buffer);
        }
        catch (Error | RuntimeException t) {
            promise.setFailure(t);
            buffer.release();
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)this);
        }
        ctx.write((Object)buffer, promise);
    }

    @Override
    public abstract int getDataLength();

    protected abstract void getBytes(ByteBuf var1);
}

