/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class AuthenticationResponse
extends AbstractXrootdResponse<AuthenticationRequest> {
    private final String protocol;
    private final int step;
    private final List<XrootdBucket> buckets;
    private final int length;

    public static void writeBytes(ByteBuf buffer, String protocol, int step, List<XrootdBucket> buckets) {
        byte[] bytes = protocol.getBytes(StandardCharsets.US_ASCII);
        buffer.writeBytes(bytes);
        buffer.writeZero(4 - bytes.length);
        buffer.writeInt(step);
        for (XrootdBucket bucket : buckets) {
            bucket.serialize(buffer);
        }
        buffer.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
    }

    public AuthenticationResponse(AuthenticationRequest request, int status, int length, String protocol, int step, List<XrootdBucket> buckets) {
        super(request, status);
        Preconditions.checkArgument((protocol.length() <= 4 ? 1 : 0) != 0);
        this.protocol = protocol;
        this.step = step;
        this.buckets = buckets;
        this.length = length;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStep() {
        return this.step;
    }

    @Override
    public int getDataLength() {
        return 8 + this.length + 4;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        AuthenticationResponse.writeBytes(buffer, this.protocol, this.step, this.buckets);
    }
}

