/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class PrepareRequest
extends AbstractXrootdRequest {
    private final int options;
    private final int priority;
    private final String[] plist;

    public PrepareRequest(ByteBuf buffer) {
        super(buffer, 3021);
        this.options = buffer.getUnsignedShort(4);
        this.priority = buffer.getUnsignedShort(5);
        int plen = buffer.getInt(20);
        int end = 24 + plen;
        this.plist = buffer.toString(24, end - 24, StandardCharsets.US_ASCII).split("\n");
    }

    public int getOptions() {
        return this.options;
    }

    public int getPriority() {
        return this.priority;
    }

    public String[] getPathList() {
        return this.plist;
    }

    public boolean isCancel() {
        return (this.getOptions() & 1) == 1;
    }

    public boolean isNotify() {
        return (this.getOptions() & 2) == 2;
    }

    public boolean isNoErrors() {
        return (this.getOptions() & 4) == 4;
    }

    public boolean isStage() {
        return (this.getOptions() & 8) == 8;
    }

    public boolean isWriteMode() {
        return (this.getOptions() & 0x10) == 16;
    }

    public boolean isColocate() {
        return (this.getOptions() & 0x20) == 32;
    }

    public boolean isFresh() {
        return (this.getOptions() & 0x40) == 64;
    }

    public String toString() {
        return String.format("prepare[%d,%d,%s]", this.options, this.priority, Arrays.toString(this.plist));
    }
}

