/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.protocol.messages.PathRequest;

public class StatRequest
extends PathRequest {
    private final short options;
    private final int fhandle;

    public StatRequest(ByteBuf buffer) {
        super(buffer, 3017);
        this.options = buffer.getUnsignedByte(4);
        this.fhandle = buffer.getInt(16);
    }

    public boolean isVfsSet() {
        return (this.options & 1) == 1;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    private short getOptions() {
        return this.options;
    }

    public Target getTarget() {
        return this.getPath().isEmpty() ? Target.FHANDLE : Target.PATH;
    }

    public String toString() {
        return String.format("stat[%#x,%s,%s]", this.getOptions(), this.getPath(), this.getOpaque());
    }

    public static enum Target {
        PATH,
        FHANDLE;

    }
}

