/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedBucketBuffer
extends XrootdBucket {
    private static final Logger _logger = LoggerFactory.getLogger(NestedBucketBuffer.class);
    private final Map<XrootdSecurityProtocol.BucketType, XrootdBucket> _nestedBuckets;
    private final String _protocol;
    private final int _step;

    public NestedBucketBuffer(XrootdSecurityProtocol.BucketType type, String protocol, int step, Map<XrootdSecurityProtocol.BucketType, XrootdBucket> nestedBuckets) {
        super(type);
        this._protocol = protocol;
        this._step = step;
        this._nestedBuckets = nestedBuckets;
    }

    public static NestedBucketBuffer deserialize(XrootdSecurityProtocol.BucketType type, ByteBuf buffer) throws IOException {
        int readIndex = buffer.readerIndex();
        String protocol = AuthenticationRequest.deserializeProtocol(buffer);
        int step = AuthenticationRequest.deserializeStep(buffer);
        _logger.debug("NestedBucketBuffer protocol: {}, step {}", (Object)protocol, (Object)step);
        if (step < 1000 || step > 1003) {
            buffer.readerIndex(readIndex);
            throw new IOException("Buffer contents are not a nested buffer!");
        }
        return new NestedBucketBuffer(type, protocol, step, AuthenticationRequest.deserializeBuckets(buffer));
    }

    public Map<XrootdSecurityProtocol.BucketType, XrootdBucket> getNestedBuckets() {
        return this._nestedBuckets;
    }

    public int getStep() {
        return this._step;
    }

    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public void serialize(ByteBuf out) {
        super.serialize(out);
        int start = out.writerIndex();
        out.writeInt(0);
        byte[] protocol = this._protocol.getBytes(StandardCharsets.US_ASCII);
        out.writeBytes(protocol);
        out.writeZero(4 - protocol.length);
        out.writeInt(this._step);
        for (XrootdBucket bucket : this._nestedBuckets.values()) {
            bucket.serialize(out);
        }
        out.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
        out.setInt(start, out.writerIndex() - start - 4);
    }

    @Override
    public int getSize() {
        int size = super.getSize() + 4 + 4 + 4;
        for (XrootdBucket bucket : this._nestedBuckets.values()) {
            size += bucket.getSize();
        }
        return size + 4;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("begin nested BucketBuffer\n");
        for (XrootdBucket bucket : this._nestedBuckets.values()) {
            sb.append(bucket.toString());
        }
        sb.append("end nested BucketBuffer\n");
        return sb.toString();
    }
}

