/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.security.SecurityInfo;
import org.dcache.xrootd.tpc.AbstractClientRequestHandler;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundHandshakeResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundLoginResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundProtocolResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundLoginRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundProtocolRequest;

public class TpcClientConnectHandler
extends AbstractClientRequestHandler {
    @Override
    protected void doOnAsynResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3007: {
                this.sendLoginRequest(ctx);
                break;
            }
            case 3006: {
                this.sendProtocolRequest(ctx);
                break;
            }
            default: {
                super.doOnAsynResponse(ctx, response);
            }
        }
    }

    @Override
    protected void doOnHandshakeResponse(ChannelHandlerContext ctx, InboundHandshakeResponse response) {
        this.client.setPval(response.getPval());
        this.client.setFlag(response.getFlag());
        this.sendProtocolRequest(ctx);
    }

    @Override
    protected void doOnProtocolResponse(ChannelHandlerContext ctx, InboundProtocolResponse response) throws XrootdException {
        int status = response.getStatus();
        ChannelId id = ctx.channel().id();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.trace("Protocol response on {}, channel {}, stream {}, received, signing policy {}; status {}.", new Object[]{tpcInfo.getSrc(), id, streamId, response.getSigningPolicy(), status});
        if (status != 0) {
            String error = String.format("Protocol request to %s failed with status %d.", tpcInfo.getSrc(), status);
            throw new XrootdException(4003, error);
        }
        this.client.setSigningPolicy(response.getSigningPolicy());
        LOGGER.trace("Protocol request to {}, channel {}, stream {}, succeeded; sending login request.", new Object[]{tpcInfo.getSrc(), id, streamId});
        this.sendLoginRequest(ctx);
    }

    @Override
    protected void doOnLoginResponse(ChannelHandlerContext ctx, InboundLoginResponse response) throws XrootdException {
        int status = response.getStatus();
        ChannelId id = ctx.channel().id();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.trace("Login response on {}, channel {}, stream {}, received; sessionId {}, status {}.", new Object[]{tpcInfo.getSrc(), id, streamId, response.getSessionId(), status});
        if (status == 0) {
            this.client.setSessionId(response.getSessionId());
            List<SecurityInfo> protocols = response.getProtocols();
            Map<String, ChannelHandler> handlers = this.client.getAuthnHandlers();
            String last = "connect";
            ChannelPipeline pipeline = ctx.pipeline();
            for (SecurityInfo protocol : protocols) {
                String name = protocol.getProtocol();
                ChannelHandler handler = handlers.get(name);
                if (handler == null) continue;
                pipeline.addAfter(last, name, handler);
                last = name;
                LOGGER.debug("Login to {}, channel {}, stream {}, sessionId {}, adding {} handler to pipeline.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId(), name});
            }
        } else {
            String error = String.format("Login to %s failed: status %d.", tpcInfo.getSrc(), status);
            throw new XrootdException(4003, error);
        }
        LOGGER.trace("Login to {}, channel {}, stream {}, succeeded; sessionId {}; passing to next handler.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId()});
        ctx.fireChannelRead((Object)response);
    }

    @Override
    protected void doOnWaitResponse(ChannelHandlerContext ctx, AbstractXrootdInboundResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3007: {
                this.client.getExecutor().schedule(() -> this.sendLoginRequest(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            case 3006: {
                this.client.getExecutor().schedule(() -> this.sendProtocolRequest(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            default: {
                super.doOnWaitResponse(ctx, response);
            }
        }
    }

    @Override
    protected void sendLoginRequest(ChannelHandlerContext ctx) {
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.trace("sendLoginRequest to {}, channel {}, stream {}, pid {}, uname {}.", new Object[]{tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), this.client.getPid(), this.client.getUname()});
        this.client.setExpectedResponse(3007);
        ctx.writeAndFlush((Object)new OutboundLoginRequest(this.client.getStreamId(), this.client.getPid(), this.client.getUname(), tpcInfo.getLoginToken()), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }

    protected void sendProtocolRequest(ChannelHandlerContext ctx) {
        ChannelId id = ctx.channel().id();
        LOGGER.trace("sendProtocolRequestForClient to {}, channel {}, stream {}.", new Object[]{this.client.getInfo().getSrc(), id, this.client.getStreamId()});
        this.client.setExpectedResponse(3006);
        ctx.writeAndFlush((Object)new OutboundProtocolRequest(this.client.getStreamId(), 649), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }
}

