/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.security.BufferEncrypter;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundSigverRequest;
import org.dcache.xrootd.tpc.protocol.messages.XrootdOutboundRequest;

public class TpcSigverRequestEncoder
extends ChannelOutboundHandlerAdapter {
    private final BufferEncrypter encrypter;
    private final SigningPolicy signingLevel;
    private long seqno;

    public TpcSigverRequestEncoder(BufferEncrypter encrypter, SigningPolicy signingLevel) {
        this.encrypter = encrypter;
        this.signingLevel = signingLevel;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        OutboundSigverRequest sigverRequest;
        XrootdOutboundRequest request;
        int streamId;
        if (msg instanceof XrootdOutboundRequest && (streamId = (request = (XrootdOutboundRequest)msg).getStreamId()) != 0 && (sigverRequest = this.createSigverRequest(ctx, request)) != null) {
            sigverRequest.writeTo(ctx, ctx.newPromise());
        }
        super.write(ctx, msg, promise);
    }

    private OutboundSigverRequest createSigverRequest(ChannelHandlerContext ctx, XrootdOutboundRequest request) throws XrootdException {
        if (!(request instanceof AbstractXrootdOutboundRequest)) {
            return null;
        }
        AbstractXrootdOutboundRequest abstractRequest = (AbstractXrootdOutboundRequest)request;
        if (!this.signingLevel.requiresSigning(abstractRequest.getRequestId())) {
            return null;
        }
        ++this.seqno;
        try {
            OutboundSigverRequest sigverRequest = new OutboundSigverRequest(this.seqno, abstractRequest, ctx);
            if (this.encrypter != null) {
                sigverRequest.encrypt(this.encrypter);
            }
            return sigverRequest;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new XrootdException(3012, e.getMessage());
        }
    }
}

