/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.tpc.AbstractClientSourceHandler;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundChecksumResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundReadResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundChecksumRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundReadRequest;

public abstract class TpcSourceReadHandler
extends AbstractClientSourceHandler {
    @Override
    protected void doOnAsynResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3013: {
                this.sendReadRequest(ctx);
                break;
            }
            case 3001: {
                this.sendChecksumRequest(ctx);
                break;
            }
            default: {
                super.doOnAsynResponse(ctx, response);
            }
        }
    }

    @Override
    protected void doOnChecksumResponse(ChannelHandlerContext ctx, InboundChecksumResponse response) throws XrootdException {
        int status = response.getStatus();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.trace("Checksum query response for {} on {}, channel {}, stream {} received, status {}.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), status});
        if (status != 0) {
            String error = String.format("Checksum query for %s failed.", tpcInfo.getLfn());
            this.handleTransferTerminated(status, error, ctx);
            return;
        }
        this.validateChecksum(response, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void doOnReadResponse(ChannelHandlerContext ctx, InboundReadResponse response) {
        block17: {
            try {
                int status = response.getStatus();
                XrootdTpcInfo tpcInfo = this.client.getInfo();
                int bytesRcvd = response.getDlen();
                LOGGER.trace("Read response received for {} on {}, channel {}, stream {}: status {}, got {} more bytes.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), status, bytesRcvd});
                if (status != 0 && status != 4000) {
                    String error = String.format("Read of %s failed with status %s.", tpcInfo.getLfn(), status);
                    this.handleTransferTerminated(4003, error, ctx);
                    return;
                }
                long writeOffset = this.client.getWriteOffset();
                if (bytesRcvd > 0) {
                    try {
                        response.setWriteOffset(writeOffset);
                        this.client.getWriteHandler().write(response);
                        this.client.setWriteOffset(writeOffset += (long)bytesRcvd);
                    }
                    catch (ClosedChannelException e) {
                        this.handleTransferTerminated(3012, "Channel " + ctx.channel().id() + " was forcefully closed by the server.", ctx);
                        ReferenceCountUtil.release((Object)response);
                        return;
                    }
                    catch (IOException e) {
                        this.handleTransferTerminated(3007, e.toString(), ctx);
                        ReferenceCountUtil.release((Object)response);
                        return;
                    }
                    LOGGER.trace("Read of {} on {}, channel {}, stream {}: wrote {}, so far {}, expected {}.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), bytesRcvd, writeOffset, tpcInfo.getAsize()});
                }
                if (status == 4000) {
                    LOGGER.trace("Waiting for more data for {} on {}, channel {}, stream {}", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId()});
                    return;
                }
                if (writeOffset < tpcInfo.getAsize()) {
                    this.sendReadRequest(ctx);
                } else if (tpcInfo.getCks() != null) {
                    this.sendChecksumRequest(ctx);
                } else {
                    LOGGER.trace("Read for {} on {}, channel {}, stream {}, completed without checksum verification.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId()});
                    this.handleTransferTerminated(0, null, ctx);
                }
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ReferenceCountUtil.release((Object)response);
            }
        }
    }

    @Override
    protected void doOnWaitResponse(ChannelHandlerContext ctx, AbstractXrootdInboundResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3013: {
                this.client.getExecutor().schedule(() -> this.sendReadRequest(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            case 3001: {
                this.client.getExecutor().schedule(() -> this.sendChecksumRequest(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            default: {
                super.doOnWaitResponse(ctx, response);
            }
        }
    }

    protected void handleTransferTerminated(int status, String error, ChannelHandlerContext ctx) {
        this.client.getWriteHandler().fireDelayedSync(status, error);
        LOGGER.trace("handleTransferTerminated called fire delayed sync, calling client shutdown");
        try {
            this.client.shutDown(ctx);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Client shutdown interrupted.");
        }
    }

    @Override
    protected void sendReadRequest(ChannelHandlerContext ctx) {
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.trace("sendReadRequest to {}, channel {}, stream {}, fhandle {}, offset {}, chunksize {}.", new Object[]{tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), this.client.getFhandle(), this.client.getWriteOffset(), this.getChunkSize()});
        this.client.setExpectedResponse(3013);
        ctx.writeAndFlush((Object)new OutboundReadRequest(this.client.getStreamId(), this.client.getFhandle(), this.client.getWriteOffset(), this.getChunkSize()), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }

    @Override
    protected void sendChecksumRequest(ChannelHandlerContext ctx) {
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.trace("sendChecksumRequest to {}, channel {}, stream {}, fhandle {}.", new Object[]{tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), this.client.getFhandle()});
        this.client.setExpectedResponse(3001);
        ctx.writeAndFlush((Object)new OutboundChecksumRequest(this.client.getStreamId(), tpcInfo.getLfn()), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }

    protected abstract void validateChecksum(InboundChecksumResponse var1, ChannelHandlerContext var2) throws XrootdException;

    protected abstract int getChunkSize();
}

