/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.tpc.protocol.messages.InboundRedirectResponse;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;

public class XrootdTpcInfo {
    public static final String STAGE = "tpc.stage";
    public static final String RENDEZVOUS_KEY = "tpc.key";
    public static final String SRC = "tpc.src";
    public static final String DST = "tpc.dst";
    public static final String LOGICAL_NAME = "tpc.lfn";
    public static final String CLIENT = "tpc.org";
    public static final String CHECKSUM = "tpc.cks";
    public static final String TIME_TO_LIVE = "tpc.ttl";
    public static final String SIZE_IN_BYTES = "oss.asize";
    public static final String PLACEMENT = "placement";
    public static final String COPY = "copy";
    public static final String ADLER32 = "adler32";
    public static final String CRC32 = "crc32";
    public static final String MD5 = "md5";
    private static final Set<String> TPC_KEYS = ImmutableSet.of((Object)"tpc.stage", (Object)"tpc.key", (Object)"tpc.src", (Object)"tpc.dst", (Object)"tpc.lfn", (Object)"tpc.org", (Object[])new String[]{"tpc.cks", "tpc.ttl", "oss.asize"});
    private final String key;
    private final long createdTime;
    private String org;
    private String dst;
    private String src;
    private String srcHost;
    private Integer srcPort;
    private String lfn;
    private Long ttl;
    private String cks;
    private long asize;
    private Status status;
    private int fd;
    private long startTime;
    private String external;
    private String loginToken;

    public XrootdTpcInfo(String key) {
        this.key = key;
        this.createdTime = System.currentTimeMillis();
    }

    public XrootdTpcInfo(Map<String, String> opaque) {
        this(opaque.get(RENDEZVOUS_KEY));
        this.lfn = opaque.get(LOGICAL_NAME);
        this.dst = opaque.get(DST);
        this.setSourceFromOpaque(opaque);
        this.cks = opaque.get(CHECKSUM);
        String asize = opaque.get(SIZE_IN_BYTES);
        if (asize != null) {
            this.asize = Long.parseLong(asize);
        }
        this.status = Status.READY;
        this.addExternal(opaque);
    }

    public synchronized XrootdTpcInfo addInfoFromOpaque(String slfn, Map<String, String> opaque) {
        String value;
        if (this.lfn == null) {
            this.lfn = slfn;
        }
        if (this.org == null) {
            this.org = opaque.get(CLIENT);
        }
        if (this.dst == null) {
            this.dst = opaque.get(DST);
        }
        if (this.src == null) {
            this.setSourceFromOpaque(opaque);
        }
        if (this.cks == null) {
            this.cks = opaque.get(CHECKSUM);
        }
        if ((value = opaque.get(TIME_TO_LIVE)) != null) {
            this.ttl = new Long(value);
            this.startTime = System.currentTimeMillis();
        }
        if ((value = opaque.get(SIZE_IN_BYTES)) != null) {
            this.asize = Long.parseLong(value);
        }
        if (this.status == null) {
            this.status = Status.PENDING;
        }
        this.addExternal(opaque);
        return this;
    }

    public XrootdTpcInfo copyForRedirect(InboundRedirectResponse response) throws ParseException {
        XrootdTpcInfo info = new XrootdTpcInfo(this.key);
        URL url = response.getUrl();
        if (url != null) {
            info.srcHost = url.getHost();
            info.srcPort = url.getPort();
        } else {
            info.srcHost = response.getHost();
            info.srcPort = response.getPort();
        }
        info.src = info.srcHost + ":" + info.srcPort;
        info.lfn = this.lfn;
        info.asize = this.asize;
        info.cks = this.cks;
        info.loginToken = response.getToken();
        String opaque = response.getOpaque();
        if (opaque == null && url != null) {
            opaque = url.getQuery();
        }
        if (opaque != null) {
            if (!opaque.startsWith("?")) {
                opaque = "?" + opaque;
            }
            info.addExternal(OpaqueStringParser.getOpaqueMap(opaque));
        }
        info.status = Status.READY;
        return info;
    }

    public synchronized Status verify(String dst, String slfn, String org) {
        if (this.status == Status.ERROR) {
            return this.status;
        }
        if (this.dst == null) {
            return Status.PENDING;
        }
        this.status = dst.equals(this.dst) && slfn.equals(this.lfn) && org.equals(this.org) && !this.isExpired() ? Status.READY : Status.CANCELLED;
        return this.status;
    }

    public String toString() {
        return "(key " + this.key + ")(dst " + this.dst + ")(src " + this.srcHost + ":" + this.srcPort + ")(org " + this.org + ")(lfn " + this.lfn + ")(ttl " + this.ttl + ")(cks " + this.cks + ")(asize " + this.asize + ")(fhandle " + this.fd + ")(status " + (Object)((Object)this.status) + ")(token " + this.loginToken + ")(external [" + this.external + "])";
    }

    public boolean isExpired() {
        return this.ttl != null && System.currentTimeMillis() > this.startTime + TimeUnit.SECONDS.toMillis(this.ttl);
    }

    public long getAsize() {
        return this.asize;
    }

    public String getCks() {
        return this.cks;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public String getExternal() {
        return this.external;
    }

    public String getDst() {
        return this.dst;
    }

    public int getFd() {
        return this.fd;
    }

    public String getKey() {
        return this.key;
    }

    public String getLfn() {
        return this.lfn;
    }

    public String getLoginToken() {
        return this.loginToken;
    }

    public String getOrg() {
        return this.org;
    }

    public String getSrc() {
        return this.src;
    }

    public String getSrcHost() {
        return this.srcHost;
    }

    public Integer getSrcPort() {
        return this.srcPort;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setAsize(long asize) {
        this.asize = asize;
    }

    public void setCks(String cks) {
        this.cks = cks;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setFd(int fd) {
        this.fd = fd;
    }

    public void setLfn(String lfn) {
        this.lfn = lfn;
    }

    public void setLoginToken(String loginToken) {
        this.loginToken = loginToken;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setSrcHost(String srcHost) {
        this.srcHost = srcHost;
    }

    public void setSrcPort(Integer srcPort) {
        this.srcPort = srcPort;
    }

    public synchronized void setStatus(Status status) {
        this.status = status;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    private void addExternal(Map<String, String> opaque) {
        HashMap<String, String> external = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : opaque.entrySet()) {
            if (TPC_KEYS.contains(entry.getKey())) continue;
            external.put(entry.getKey(), entry.getValue());
        }
        this.external = OpaqueStringParser.buildOpaqueString(external);
    }

    private void setSourceFromOpaque(Map<String, String> map) {
        this.src = map.get(SRC);
        if (this.src != null) {
            String[] source = this.src.split(":");
            this.srcHost = source[0];
            if (Strings.emptyToNull((String)source[1]) != null) {
                this.srcPort = Integer.parseInt(source[1]);
            }
        }
    }

    public static enum Status {
        PENDING,
        READY,
        CANCELLED,
        ERROR;

    }
}

