/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;

public class InboundAuthenticationResponse
extends AbstractXrootdInboundResponse {
    private final Map<XrootdSecurityProtocol.BucketType, XrootdBucket> bucketMap = new EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket>(XrootdSecurityProtocol.BucketType.class);
    private int dataLength;
    private int serverStep;
    private String protocol;

    public InboundAuthenticationResponse(ByteBuf buffer) throws XrootdException {
        super(buffer);
        buffer.readerIndex(4);
        this.dataLength = buffer.readInt();
        if (this.dataLength == 0) {
            return;
        }
        this.protocol = AuthenticationRequest.deserializeProtocol(buffer);
        this.serverStep = buffer.readInt();
        try {
            this.bucketMap.putAll(AuthenticationRequest.deserializeBuckets(buffer));
            RawBucket mainBucket = (RawBucket)this.bucketMap.remove((Object)XrootdSecurityProtocol.BucketType.kXRS_main);
            ByteBuf mainBuffer = Unpooled.wrappedBuffer((byte[])mainBucket.getContent());
            mainBuffer.readerIndex(8);
            this.bucketMap.putAll(AuthenticationRequest.deserializeBuckets(mainBuffer));
        }
        catch (IOException e) {
            throw new XrootdException(3007, e.toString());
        }
    }

    public Map<XrootdSecurityProtocol.BucketType, XrootdBucket> getBuckets() {
        return this.bucketMap;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getRequestId() {
        return 3000;
    }

    public int getServerStep() {
        return this.serverStep;
    }
}

