/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;

public class InboundProtocolResponse
extends AbstractXrootdInboundResponse {
    private SigningPolicy signingPolicy;

    public InboundProtocolResponse(ByteBuf buffer) throws XrootdException {
        super(buffer);
        int len = buffer.getInt(4);
        byte secopt = 0;
        int seclvl = 0;
        HashMap<Integer, Integer> overrides = new HashMap<Integer, Integer>();
        if (len >= 14) {
            secopt = buffer.getByte(19);
            seclvl = buffer.getByte(20);
            int secvsz = buffer.getByte(21);
            int index = 22;
            for (int i = 0; i < secvsz; ++i) {
                overrides.put(Integer.valueOf(buffer.getByte(index++)), Integer.valueOf(buffer.getByte(index++)));
            }
        }
        this.signingPolicy = new SigningPolicy(seclvl, secopt, overrides);
    }

    public SigningPolicy getSigningPolicy() {
        return this.signingPolicy;
    }

    @Override
    public int getRequestId() {
        return 3006;
    }
}

