/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AuthenticationResponse;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;

public class OutboundAuthenticationRequest
extends AbstractXrootdOutboundRequest {
    private final String protocol;
    private final int step;
    private final List<XrootdBucket> buckets;
    private final int length;

    public OutboundAuthenticationRequest(int streamId, int length, String protocol, int step, List<XrootdBucket> buckets) {
        super(streamId, 3000);
        this.protocol = protocol;
        this.step = step;
        this.length = length;
        this.buckets = buckets;
    }

    @Override
    protected void getParams(ByteBuf buffer) {
        buffer.writeZero(16);
        buffer.writeInt(12 + this.length);
        AuthenticationResponse.writeBytes(buffer, this.protocol, this.step, this.buckets);
    }

    @Override
    protected int getParamsLen() {
        return this.getDataLen() + 20;
    }

    private int getDataLen() {
        return 12 + this.length;
    }
}

