/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.dcache.xrootd.tpc.protocol.messages.XrootdOutboundRequest;

public class OutboundProtocolRequest
implements XrootdOutboundRequest {
    private static final byte[] RESERVED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int streamId;
    private int version;

    public OutboundProtocolRequest(int streamId, int version) {
        this.streamId = streamId;
        this.version = version;
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        ByteBuf buffer = ctx.alloc().buffer(24);
        try {
            buffer.writeShort(this.streamId);
            buffer.writeShort(3006);
            buffer.writeInt(this.version);
            buffer.writeBytes(RESERVED);
            buffer.writeByte(1);
            buffer.writeInt(0);
        }
        catch (Error | RuntimeException t) {
            promise.setFailure(t);
            buffer.release();
            return;
        }
        ctx.write((Object)buffer, promise);
    }
}

