/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.security.BufferEncrypter;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;

public class OutboundSigverRequest
extends AbstractXrootdOutboundRequest {
    public static final byte kXR_SHA256 = 1;
    private static final byte[] RESERVED = new byte[]{0, 0, 0};
    private final long seqno;
    private final int expectrid;
    private byte[] signature;

    public OutboundSigverRequest(long seqno, AbstractXrootdOutboundRequest request, ChannelHandlerContext ctx) throws NoSuchAlgorithmException {
        super(request.getStreamId(), 3029);
        this.seqno = seqno;
        this.expectrid = request.getRequestId();
        this.signature = this.getSignature(request, ctx);
    }

    public void encrypt(BufferEncrypter encrypter) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException {
        this.signature = encrypter.encrypt(this.signature);
    }

    @Override
    protected void getParams(ByteBuf buffer) {
        buffer.writeShort(this.expectrid);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeLong(this.seqno);
        buffer.writeByte(1);
        buffer.writeBytes(RESERVED);
        buffer.writeInt(this.signature.length);
        buffer.writeBytes(this.signature);
    }

    @Override
    protected int getParamsLen() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSignature(AbstractXrootdOutboundRequest request, ChannelHandlerContext ctx) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteBuf buffer = ctx.alloc().buffer(12 + request.getParamsLen());
        try {
            buffer.writeLong(this.seqno);
            request.writeToBuffer(buffer);
            byte[] contents = new byte[buffer.readableBytes()];
            buffer.getBytes(0, contents);
            byte[] byArray = digest.digest(contents);
            return byArray;
        }
        finally {
            buffer.release();
        }
    }
}

