/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.util;

import java.util.Map;
import java.util.Optional;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;

public class ChecksumInfo {
    private static final String KEY = "cks.type";
    private final String path;
    private final Optional<String> type;

    public ChecksumInfo(String args) throws XrootdException {
        int i = args.indexOf("?");
        if (i == -1) {
            this.path = args;
            this.type = Optional.empty();
        } else {
            this.path = args.substring(0, i);
            String query = args.substring(i);
            try {
                Map<String, String> map = OpaqueStringParser.getOpaqueMap(query);
                this.type = Optional.ofNullable(map.get(KEY));
            }
            catch (ParseException e) {
                throw new XrootdException(3006, "malformed checksum query part: " + query);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public Optional<String> getType() {
        return this.type;
    }
}

