/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.util;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dcache.xrootd.util.ParseException;

public class OpaqueStringParser {
    public static final char OPAQUE_STRING_PREFIX = '?';
    public static final char OPAQUE_PREFIX = '&';
    public static final char OPAQUE_SEPARATOR = '=';

    public static Map<String, String> getOpaqueMap(String opaque) throws ParseException {
        String[] prefixBlocks;
        if (opaque == null || opaque.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String prefixBlock : prefixBlocks = opaque.split("\\?")) {
            String[] prefixSubBlocks;
            if (prefixBlock.isEmpty()) continue;
            for (String prefixSubBlock : prefixSubBlocks = prefixBlock.split("&")) {
                if (prefixSubBlock.isEmpty()) continue;
                int delimiter = prefixSubBlock.indexOf(61);
                if (delimiter == -1) {
                    throw new ParseException("Opaque information is missing avalue for variable " + prefixSubBlock);
                }
                map.put(prefixSubBlock.substring(0, delimiter), prefixSubBlock.substring(delimiter + 1, prefixSubBlock.length()));
            }
        }
        return map;
    }

    public static String buildOpaqueString(String key, String value) {
        return '&' + key + '=' + value;
    }

    public static String buildOpaqueString(Map<String, String> map) {
        return Joiner.on((char)'&').withKeyValueSeparator("=").join(map);
    }
}

