/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationResponse
extends AbstractXrootdResponse<AuthenticationRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationResponse.class);
    private final String protocol;
    private final int step;
    private final List<XrootdBucket> buckets;
    private final int length;

    public static void writeBytes(ByteBuf buffer, String protocol, int step, List<XrootdBucket> buckets) {
        byte[] bytes = protocol.getBytes(StandardCharsets.US_ASCII);
        buffer.writeBytes(bytes);
        buffer.writeZero(4 - bytes.length);
        buffer.writeInt(step);
        for (XrootdBucket bucket : buckets) {
            bucket.serialize(buffer);
        }
        buffer.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.describe());
        }
        super.writeTo(ctx, promise);
    }

    public AuthenticationResponse(AuthenticationRequest request, int status, int length, String protocol, int step, List<XrootdBucket> buckets) {
        super(request, status);
        Preconditions.checkArgument((protocol.length() <= 4 ? 1 : 0) != 0);
        this.protocol = protocol;
        this.step = step;
        this.buckets = buckets;
        this.length = length;
    }

    public String describe() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("/////////////////////////////////////////////////////////\n");
        builder.append("//               Authentication Response\n");
        builder.append("//\n");
        builder.append("//  stream:  ").append(((AuthenticationRequest)this.request).getStreamId()).append("\n");
        builder.append("//  request: ").append(((AuthenticationRequest)this.request).getRequestId()).append("\n");
        builder.append("//\n");
        int i = 0;
        for (XrootdBucket bucket : this.buckets) {
            ++i;
            i = bucket.dump(builder, XrootdSecurityProtocol.getServerStep(this.step), i);
        }
        builder.append("/////////////////////////////////////////////////////////\n");
        return builder.toString();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStep() {
        return this.step;
    }

    @Override
    public int getDataLength() {
        return 8 + this.length + 4;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        AuthenticationResponse.writeBytes(buffer, this.protocol, this.step, this.buckets);
    }
}

