/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class MvRequest
extends AbstractXrootdRequest {
    private String sourcePath;
    private String targetPath;
    private String sourceOpaque;
    private String targetOpaque;

    public MvRequest(ByteBuf buffer) {
        super(buffer, 3009);
        int dlen = buffer.getInt(20);
        int end = 24 + dlen;
        int psep = buffer.indexOf(24, end, (byte)32);
        if (psep == -1) {
            throw new IllegalArgumentException("kXR_mv needs two paths!");
        }
        String source = buffer.toString(24, psep - 24, StandardCharsets.US_ASCII);
        String target = buffer.toString(psep + 1, end - (psep + 1), StandardCharsets.US_ASCII);
        int osep = source.indexOf("?");
        if (osep > -1) {
            this.sourcePath = source.substring(0, osep);
            this.sourceOpaque = source.substring(osep + 1);
        } else {
            this.sourcePath = source;
        }
        osep = target.indexOf("?");
        if (osep > -1) {
            this.targetPath = target.substring(0, osep);
            this.targetOpaque = target.substring(osep + 1);
        } else {
            this.targetPath = target;
        }
    }

    @Deprecated
    public String getOpaque() {
        return this.targetOpaque;
    }

    @Deprecated
    public void setOpaque(String opaque) {
        this.targetOpaque = opaque;
    }

    public String getSourceOpaque() {
        return this.sourceOpaque;
    }

    public void setSourceOpaque(String sourceOpaque) {
        this.sourceOpaque = sourceOpaque;
    }

    public String getTargetOpaque() {
        return this.targetOpaque;
    }

    public void setTargetOpaque(String targetOpaque) {
        this.targetOpaque = targetOpaque;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String toString() {
        return "mv[" + this.sourcePath + "," + (this.sourceOpaque == null ? "" : "?" + this.sourceOpaque + ",") + this.targetPath + "," + (this.targetOpaque == null ? "" : "?" + this.targetOpaque + ",") + "]";
    }
}

