/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.CharMatcher;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class QueryRequest
extends AbstractXrootdRequest {
    public static final CharMatcher NULL_CHARACTER = CharMatcher.is((char)'\u0000');
    private final int reqcode;
    private final int fhandle;
    private final String args;
    private final String opaque;
    private String path;

    public QueryRequest(ByteBuf buffer) {
        super(buffer, 3001);
        this.reqcode = buffer.getUnsignedShort(4);
        this.fhandle = buffer.getInt(8);
        int alen = buffer.getInt(20);
        this.args = NULL_CHARACTER.trimTrailingFrom((CharSequence)buffer.toString(24, alen, StandardCharsets.US_ASCII));
        switch (this.reqcode) {
            case 3: 
            case 4: {
                int pos = this.args.indexOf(63);
                if (pos > -1) {
                    this.path = this.args.substring(0, pos);
                    this.opaque = this.args.substring(pos + 1);
                    break;
                }
                this.path = this.args;
                this.opaque = "";
                break;
            }
            default: {
                this.path = null;
                this.opaque = null;
            }
        }
    }

    public int getReqcode() {
        return this.reqcode;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    public String getArgs() {
        return this.args;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return String.format("query[%d,%d,%s]", this.reqcode, this.fhandle, this.args);
    }
}

