/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCounted;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;

public class ReadResponse
implements XrootdResponse<ReadRequest>,
ReferenceCounted {
    private final ReadRequest request;
    private final int stat;
    private final ByteBuf data;

    public ReadResponse(ReadRequest request, ByteBuf data, boolean isIncomplete) {
        this.request = (ReadRequest)Preconditions.checkNotNull((Object)request);
        this.stat = isIncomplete ? 4000 : 0;
        this.data = (ByteBuf)Preconditions.checkNotNull((Object)data);
    }

    @Override
    public ReadRequest getRequest() {
        return this.request;
    }

    @Override
    public int getStatus() {
        return this.stat;
    }

    @Override
    public int getDataLength() {
        return this.data.readableBytes();
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        Preconditions.checkState((this.refCnt() > 0 ? 1 : 0) != 0);
        ByteBuf header = ctx.alloc().buffer(8);
        header.writeShort(this.request.getStreamId());
        header.writeShort(this.stat);
        header.writeInt(this.data.readableBytes());
        ctx.write((Object)ctx.alloc().compositeBuffer(2).addComponents(new ByteBuf[]{header, this.data}).writerIndex(8 + this.data.readableBytes()), promise);
    }

    public ByteBuf getData() {
        return this.data.asReadOnly();
    }

    public String toString() {
        return String.format("read-response[stat=%d,bytes=%d]", this.stat, this.data.readableBytes());
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public ReadResponse retain() {
        this.data.retain();
        return this;
    }

    public ReadResponse retain(int increment) {
        this.data.retain(increment);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int decrement) {
        return this.data.release(decrement);
    }

    public ReferenceCounted touch() {
        this.data.touch();
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        this.data.touch(hint);
        return this;
    }
}

