/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Map;

public class SigningPolicy {
    private final int secLvl;
    private final Map<Integer, Integer> overrides;
    private final byte secOFrce;

    public SigningPolicy() {
        this(0, Collections.EMPTY_MAP);
    }

    public SigningPolicy(int secLvl, boolean force) {
        this(secLvl, force ? (byte)2 : 0, Collections.EMPTY_MAP);
    }

    public SigningPolicy(int secLvl, Map<Integer, Integer> overrides) {
        this(secLvl, 0, overrides);
    }

    public SigningPolicy(int secLvl, byte secOFrce, Map<Integer, Integer> overrides) {
        this.secLvl = secLvl;
        this.secOFrce = secOFrce;
        this.overrides = overrides;
    }

    public boolean isForceSigning() {
        return this.secOFrce == 2;
    }

    public boolean isSigningOn() {
        return this.secLvl > 0;
    }

    public boolean requiresSigning(int requestId) {
        int signingLevel;
        Integer override = this.overrides.get(requestId);
        if (override == null) {
            override = 0;
        }
        switch (requestId) {
            case 3001: 
            case 3004: 
            case 3013: 
            case 3016: 
            case 3017: 
            case 3021: 
            case 3022: 
            case 3025: 
            case 3027: {
                signingLevel = 4;
                break;
            }
            case 3003: 
            case 3019: 
            case 3023: {
                signingLevel = 3;
                break;
            }
            case 3008: 
            case 3009: 
            case 3010: 
            case 3014: 
            case 3015: 
            case 3018: {
                signingLevel = 1;
                break;
            }
            default: {
                signingLevel = 0;
            }
        }
        return signingLevel != 0 && (this.secLvl >= signingLevel || override == 2);
    }

    public String toString() {
        return "(secLvl " + this.secLvl + ")(overrides " + this.overrides + ")(force " + this.isForceSigning() + ")";
    }

    public void writeBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.secOFrce);
        buffer.writeByte(this.secLvl);
        buffer.writeByte(this.overrides.size());
        for (Map.Entry<Integer, Integer> entry : this.overrides.entrySet()) {
            buffer.writeByte(entry.getKey().intValue());
            buffer.writeByte(entry.getValue().intValue());
        }
    }
}

