/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.UnsignedIntBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public abstract class XrootdBucket {
    protected final XrootdSecurityProtocol.BucketType _type;

    public XrootdBucket(XrootdSecurityProtocol.BucketType type) {
        this._type = type;
    }

    public int dump(StringBuilder builder, String step, int number) {
        builder.append("//                                                     //\n");
        builder.append("//                    XrootdBucket                     //\n");
        builder.append("//                                                     //\n");
        builder.append("//  Name: ").append(this.getClass().getSimpleName()).append("\n");
        builder.append("//  Step: ").append(step).append("\n");
        builder.append("//  Buck: ").append(number).append("\n");
        builder.append("//  Type: ").append(this._type.name()).append("\n");
        builder.append("//  Size: ").append(this.getSize()).append("\n");
        return number;
    }

    public XrootdSecurityProtocol.BucketType getType() {
        return this._type;
    }

    public void serialize(ByteBuf out) {
        out.writeInt(this._type.getCode());
    }

    public static XrootdBucket deserialize(XrootdSecurityProtocol.BucketType type, ByteBuf buffer) throws IOException {
        XrootdBucket bucket;
        switch (type) {
            case kXRS_main: {
                try {
                    bucket = NestedBucketBuffer.deserialize(type, buffer);
                }
                catch (IOException e) {
                    bucket = RawBucket.deserialize(type, buffer);
                }
                break;
            }
            case kXRS_cryptomod: 
            case kXRS_issuer_hash: 
            case kXRS_rtag: 
            case kXRS_puk: 
            case kXRS_cipher_alg: 
            case kXRS_x509: 
            case kXRS_x509_req: 
            case kXRS_md_alg: 
            case kXRS_message: {
                bucket = StringBucket.deserialize(type, buffer);
                break;
            }
            case kXRS_version: 
            case kXRS_clnt_opts: {
                bucket = UnsignedIntBucket.deserialize(type, buffer);
                break;
            }
            default: {
                bucket = RawBucket.deserialize(type, buffer);
            }
        }
        return bucket;
    }

    public int getSize() {
        return 4;
    }

    public String toString() {
        return "bucket type: " + (Object)((Object)this._type) + "\n";
    }
}

