/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.tpc.AbstractClientRequestHandler;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundChecksumResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundCloseResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundLoginResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundOpenReadOnlyResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundReadResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundOpenReadOnlyRequest;

public abstract class AbstractClientSourceHandler
extends AbstractClientRequestHandler {
    @Override
    protected void doOnLoginResponse(ChannelHandlerContext ctx, InboundLoginResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.debug("login response to {} received, channel {}, stream {}.", new Object[]{tpcInfo.getSrc(), id, this.client.getStreamId()});
        if (!response.getProtocols().isEmpty()) {
            String error = String.format("Authentication to %s failed; all protocols have been tried.", tpcInfo.getSrc());
            throw new XrootdException(3010, error);
        }
        LOGGER.debug("login of {} on {}, channel {}, stream {}, complete, proceeding to open.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), id, this.client.getStreamId()});
        this.sendOpenRequest(ctx);
    }

    @Override
    protected void doOnAsynResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3010: {
                this.sendOpenRequest(ctx);
                break;
            }
            case 3003: {
                this.client.doClose(ctx);
                break;
            }
            default: {
                super.doOnAsynResponse(ctx, response);
            }
        }
    }

    @Override
    protected void doOnAuthenticationResponse(ChannelHandlerContext ctx, InboundAuthenticationResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.debug("authentication of {} on {}, channel {}, stream {}, complete, proceeding to open.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), id, this.client.getStreamId()});
        this.sendOpenRequest(ctx);
    }

    @Override
    protected void doOnCloseResponse(ChannelHandlerContext ctx, InboundCloseResponse response) throws XrootdException {
        int status = response.getStatus();
        ChannelId id = ctx.channel().id();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.debug("Close response for {} on {}, channel {}, stream {}, received with status {}.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), id, this.client.getStreamId(), status});
        switch (status) {
            case 0: {
                LOGGER.debug("Close of {} on {}, channel {}, stream {}, succeeded, ending session.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), id, this.client.getStreamId()});
                this.client.doEndsession(ctx);
                break;
            }
            default: {
                String error = String.format("Close of %s on %s failed with status %s.", tpcInfo.getLfn(), tpcInfo.getSrc(), status);
                throw new XrootdException(3007, error);
            }
        }
        this.client.setOpenFile(false);
    }

    @Override
    protected void doOnOpenResponse(ChannelHandlerContext ctx, InboundOpenReadOnlyResponse response) throws XrootdException {
        int status = response.getStatus();
        ChannelId id = ctx.channel().id();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.debug("Open response for {} on {} received, channel {}, stream {}, fhandle {}, cpsize {}, cptype {}; status {}.", new Object[]{tpcInfo.getLfn(), tpcInfo.getSrc(), id, this.client.getStreamId(), response.getFhandle(), response.getCpsize(), response.getCptype(), status});
        if (status != 0) {
            String error = String.format("Open of %s on %s failed with status %s.", tpcInfo.getLfn(), tpcInfo.getSrc(), status);
            throw new XrootdException(3007, error);
        }
        this.client.setOpenFile(true);
        this.client.setFhandle(response.getFhandle());
        this.client.setCpsize(response.getCpsize());
        this.client.setCptype(response.getCptype());
        this.sendReadRequest(ctx);
    }

    @Override
    protected void sendOpenRequest(ChannelHandlerContext ctx) {
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        LOGGER.debug("sendOpenRequest to {}, channel {}, stream {}, path {}.", new Object[]{tpcInfo.getSrc(), ctx.channel().id(), this.client.getStreamId(), this.client.getFullpath()});
        this.client.setExpectedResponse(3010);
        ctx.writeAndFlush((Object)new OutboundOpenReadOnlyRequest(this.client.getStreamId(), this.client.getFullpath()), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }

    @Override
    protected void doOnWaitResponse(ChannelHandlerContext ctx, AbstractXrootdInboundResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3010: {
                this.client.getExecutor().schedule(() -> this.sendOpenRequest(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            case 3003: {
                this.client.getExecutor().schedule(() -> this.client.doClose(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            default: {
                super.doOnWaitResponse(ctx, response);
            }
        }
    }

    @Override
    protected abstract void doOnChecksumResponse(ChannelHandlerContext var1, InboundChecksumResponse var2) throws XrootdException;

    @Override
    protected abstract void doOnReadResponse(ChannelHandlerContext var1, InboundReadResponse var2) throws XrootdException;

    @Override
    protected abstract void sendChecksumRequest(ChannelHandlerContext var1) throws XrootdException;

    @Override
    protected abstract void sendReadRequest(ChannelHandlerContext var1) throws XrootdException;
}

