/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundAuthenticationResponse
extends AbstractXrootdInboundResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboundAuthenticationResponse.class);
    private final Map<XrootdSecurityProtocol.BucketType, XrootdBucket> bucketMap = new EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket>(XrootdSecurityProtocol.BucketType.class);
    private int dataLength;
    private int serverStep;
    private String protocol;

    public InboundAuthenticationResponse(ByteBuf buffer) throws XrootdException {
        super(buffer);
        buffer.readerIndex(4);
        this.dataLength = buffer.readInt();
        if (this.dataLength == 0) {
            return;
        }
        this.protocol = AuthenticationRequest.deserializeProtocol(buffer);
        this.serverStep = buffer.readInt();
        try {
            this.bucketMap.putAll(AuthenticationRequest.deserializeBuckets(buffer));
            if (this.serverStep != 2002) {
                RawBucket mainBucket = (RawBucket)this.bucketMap.remove((Object)XrootdSecurityProtocol.BucketType.kXRS_main);
                ByteBuf mainBuffer = Unpooled.wrappedBuffer((byte[])mainBucket.getContent());
                mainBuffer.readerIndex(8);
                this.bucketMap.putAll(AuthenticationRequest.deserializeBuckets(mainBuffer));
            }
        }
        catch (IOException e) {
            throw new XrootdException(3007, e.toString());
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.describe());
        }
    }

    public String describe() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("/////////////////////////////////////////////////////////\n");
        builder.append("//           Inbound Authentication Response\n");
        builder.append("//\n");
        builder.append("//  stream:  ").append(this.streamId).append("\n");
        builder.append("//  stat:    ").append(this.stat).append("\n");
        builder.append("//\n");
        int i = 0;
        Collection<XrootdBucket> buckets = this.bucketMap.values();
        for (XrootdBucket bucket : buckets) {
            ++i;
            i = bucket.dump(builder, XrootdSecurityProtocol.getServerStep(this.serverStep), i);
        }
        builder.append("/////////////////////////////////////////////////////////\n");
        return builder.toString();
    }

    public Map<XrootdSecurityProtocol.BucketType, XrootdBucket> getBuckets() {
        return this.bucketMap;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getRequestId() {
        return 3000;
    }

    public int getServerStep() {
        return this.serverStep;
    }
}

