/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AuthenticationResponse;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundAuthenticationRequest
extends AbstractXrootdOutboundRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundAuthenticationRequest.class);
    private final String protocol;
    private final int step;
    private final List<XrootdBucket> buckets;
    private final int length;

    public OutboundAuthenticationRequest(int streamId, int length, String protocol, int step, List<XrootdBucket> buckets) {
        super(streamId, 3000);
        this.protocol = protocol;
        this.step = step;
        this.length = length;
        this.buckets = buckets;
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.describe());
        }
        super.writeTo(ctx, promise);
    }

    public String describe() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("/////////////////////////////////////////////////////////\n");
        builder.append("//           Outbound Authentication Response\n");
        builder.append("//\n");
        builder.append("//  stream:  ").append(this.streamId).append("\n");
        builder.append("//  request: ").append(this.requestId).append("\n");
        builder.append("//\n");
        int i = 0;
        for (XrootdBucket bucket : this.buckets) {
            ++i;
            i = bucket.dump(builder, XrootdSecurityProtocol.getClientStep(this.step), i);
        }
        builder.append("/////////////////////////////////////////////////////////\n");
        return builder.toString();
    }

    @Override
    protected void getParams(ByteBuf buffer) {
        buffer.writeZero(16);
        buffer.writeInt(12 + this.length);
        AuthenticationResponse.writeBytes(buffer, this.protocol, this.step, this.buckets);
    }

    @Override
    protected int getParamsLen() {
        return this.getDataLen() + 20;
    }

    private int getDataLen() {
        return 12 + this.length;
    }
}

