/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import java.util.Properties;
import java.util.ServiceLoader;
import org.dcache.xrootd.core.XrootdAuthenticationHandlerFactory;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationProvider;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.ChannelHandlerProvider;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.plugins.ProxyDelegationClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthenticationHandlerProvider
implements ChannelHandlerProvider {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthenticationHandlerProvider.class);
    static final String PREFIX = "authn:";
    private static ClassLoader _classLoader;

    public static void setPluginClassLoader(ClassLoader classLoader) {
        _classLoader = classLoader;
    }

    @Override
    public ChannelHandlerFactory createFactory(String plugin, Properties properties) throws Exception {
        String name;
        AuthenticationFactory authnFactory;
        if (plugin.startsWith(PREFIX) && (authnFactory = this.createAuthnFactory(name = plugin.substring(PREFIX.length()), properties)) != null) {
            ProxyDelegationClient client = this.createClient(name, properties);
            return new XrootdAuthenticationHandlerFactory(name, authnFactory, client);
        }
        return null;
    }

    private AuthenticationFactory createAuthnFactory(String name, Properties properties) throws Exception {
        ServiceLoader<AuthenticationProvider> providers = _classLoader == null ? ServiceLoader.load(AuthenticationProvider.class) : ServiceLoader.load(AuthenticationProvider.class, _classLoader);
        for (AuthenticationProvider provider : providers) {
            AuthenticationFactory factory = provider.createFactory(name, properties);
            if (factory != null) {
                _log.debug("AuthenticationHandler plugin {} is provided by {}", (Object)name, provider.getClass());
                return factory;
            }
            _log.debug("AuthenticationHandler plugin {} could not be provided by {}", (Object)name, provider.getClass());
        }
        return null;
    }

    private ProxyDelegationClient createClient(String name, Properties properties) throws Exception {
        ServiceLoader<ProxyDelegationClientFactory> factories = _classLoader == null ? ServiceLoader.load(ProxyDelegationClientFactory.class) : ServiceLoader.load(ProxyDelegationClientFactory.class, _classLoader);
        for (ProxyDelegationClientFactory factory : factories) {
            Object client = factory.createClient(name, properties);
            if (client == null) continue;
            _log.debug("Creating a credential store client for {} using {}.", (Object)name, factory.getClass());
            return client;
        }
        return null;
    }
}

