/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol;

public interface XrootdProtocol {
    public static final int DEFAULT_PORT = 1094;
    public static final byte CLIENT_REQUEST_LEN = 24;
    public static final byte CLIENT_HANDSHAKE_LEN = 20;
    public static final byte SERVER_RESPONSE_LEN = 8;
    public static final int SESSION_ID_SIZE = 16;
    public static final byte OPAQUE_DELIMITER = 63;
    public static final String UUID_PREFIX = "org.dcache.uuid";
    public static final int PROTOCOL_VERSION = 1280;
    public static final int PROTOCOL_SIGN_VERSION = 784;
    public static final int PROTOCOL_TLS_VERSION = 1280;
    public static final byte PROTOCOL_VERSION_MAJOR = 5;
    public static final byte PROTOCOL_VERSION_MINOR = 0;
    public static final int TPC_VERSION = 1;
    public static final int kXR_LBalServer = 0;
    public static final int kXR_DataServer = 1;
    public static final int kXR_isManager = 2;
    public static final int kXR_isServer = 1;
    public static final int kXR_attrMeta = 256;
    public static final int kXR_attrProxy = 512;
    public static final int kXR_attrSuper = 1024;
    public static final int LOAD_BALANCER = 0;
    public static final int DATA_SERVER = 1;
    public static final byte[] HANDSHAKE_REQUEST = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 7, -36};
    public static final byte[] HANDSHAKE_RESPONSE_LOADBALANCER = new byte[]{0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 5, 0, 0, 0, 0, 0};
    public static final byte[] HANDSHAKE_RESPONSE_DATASERVER = new byte[]{0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 5, 0, 0, 0, 0, 1};
    public static final int kXR_handshake = 0;
    public static final int kXR_auth = 3000;
    public static final int kXR_query = 3001;
    public static final int kXR_chmod = 3002;
    public static final int kXR_close = 3003;
    public static final int kXR_dirlist = 3004;
    public static final int kXR_gpfile = 3005;
    public static final int kXR_protocol = 3006;
    public static final int kXR_login = 3007;
    public static final int kXR_mkdir = 3008;
    public static final int kXR_mv = 3009;
    public static final int kXR_open = 3010;
    public static final int kXR_ping = 3011;
    public static final int kXR_chkpoint = 3012;
    public static final int kXR_read = 3013;
    public static final int kXR_rm = 3014;
    public static final int kXR_rmdir = 3015;
    public static final int kXR_sync = 3016;
    public static final int kXR_stat = 3017;
    public static final int kXR_set = 3018;
    public static final int kXR_write = 3019;
    public static final int kXR_fattr = 3020;
    public static final int kXR_prepare = 3021;
    public static final int kXR_statx = 3022;
    public static final int kXR_endsess = 3023;
    public static final int kXR_bind = 3024;
    public static final int kXR_readv = 3025;
    public static final int kXR_pgwrite = 3026;
    public static final int kXR_locate = 3027;
    public static final int kXR_truncate = 3028;
    public static final int kXR_sigver = 3029;
    public static final int kXR_pgread = 3030;
    public static final int kXR_writev = 3031;
    public static final int kXR_REQFENCE = 3032;
    public static final int kXR_ur = 256;
    public static final int kXR_uw = 128;
    public static final int kXR_ux = 64;
    public static final int kXR_gr = 32;
    public static final int kXR_gw = 16;
    public static final int kXR_gx = 8;
    public static final int kXR_or = 4;
    public static final int kXR_ow = 2;
    public static final int kXR_ox = 1;
    public static final int kXR_mknone = 0;
    public static final int kXR_mkdirpath = 1;
    public static final int kXR_nothing = 0;
    public static final int kXR_fullurl = 1;
    public static final int kXR_multipr = 3;
    public static final int kXR_readrdok = 4;
    public static final int kXR_hasipv64 = 8;
    public static final int kXR_onlyprv4 = 16;
    public static final int kXR_onlyprv6 = 32;
    public static final int kXR_lclfile = 64;
    public static final int kXR_lcvnone = 0;
    public static final int kXR_vermask = 63;
    public static final int kXR_asyncap = 128;
    public static final int kXR_ver000 = 0;
    public static final int kXR_ver001 = 1;
    public static final int kXR_ver002 = 2;
    public static final int kXR_ver003 = 3;
    public static final int kXR_ver004 = 4;
    public static final int kXR_ver005 = 5;
    public static final int kXR_vfs = 1;
    public static final int kXR_file = 0;
    public static final int kXR_xset = 1;
    public static final int kXR_isDir = 2;
    public static final int kXR_other = 4;
    public static final int kXR_offline = 8;
    public static final int kXR_readable = 16;
    public static final int kXR_writable = 32;
    public static final int kXR_poscpend = 64;
    public static final int kXR_bkpexist = 128;
    public static final int kXR_online = 1;
    public static final int kXR_dstat = 2;
    public static final int kXR_compress = 1;
    public static final int kXR_delete = 2;
    public static final int kXR_force = 4;
    public static final int kXR_new = 8;
    public static final int kXR_open_read = 16;
    public static final int kXR_open_updt = 32;
    public static final int kXR_async = 64;
    public static final int kXR_refresh = 128;
    public static final int kXR_mkpath = 256;
    public static final int kXR_prefname = 256;
    public static final int kXR_open_apnd = 512;
    public static final int kXR_retstat = 1024;
    public static final int kXR_replica = 2048;
    public static final int kXR_posc = 4096;
    public static final int kXR_nowait = 8192;
    public static final int kXR_seqio = 16384;
    public static final int kXR_open_wrto = 32768;
    @Deprecated
    public static final int kXR_opscpend = 64;
    public static final byte kXR_secreqs = 1;
    public static final byte kXR_ableTLS = 2;
    public static final byte kXR_wantTLS = 4;
    public static final byte kXR_expMask = 15;
    public static final byte kXR_ExpNone = 0;
    public static final byte kXR_ExpBind = 1;
    public static final byte kXR_ExpGPF = 2;
    public static final byte kXR_ExpGPFA = 32;
    public static final byte kXR_ExpLogin = 3;
    public static final byte kXR_ExpTPC = 4;
    public static final int kXR_anongpf = 0x800000;
    public static final int kXR_supgpf = 0x400000;
    public static final int kXR_suppgrw = 0x200000;
    public static final int kXR_supposc = 0x100000;
    public static final int kXR_haveTLS = Integer.MIN_VALUE;
    public static final int kXR_gotoTLS = 0x40000000;
    public static final int kXR_tlsAny = 0x1F000000;
    public static final int kXR_tlsData = 0x1000000;
    public static final int kXR_tlsGPF = 0x2000000;
    public static final int kXR_tlsGPFA = 0x20000000;
    public static final int kXR_tlsLogin = 0x4000000;
    public static final int kXR_tlsSess = 0x8000000;
    public static final int kXR_tlsTPC = 0x10000000;
    public static final int kXR_QStats = 1;
    public static final int kXR_QPrep = 2;
    public static final int kXR_Qcksum = 3;
    public static final int kXR_Qxattr = 4;
    public static final int kXR_Qspace = 5;
    public static final int kXR_Qckscan = 6;
    public static final int kXR_Qconfig = 7;
    public static final int kXR_Qvisa = 8;
    public static final int kXR_Qopaque = 16;
    public static final int kXR_Qopaquf = 32;
    public static final int kXR_Qopaqug = 64;
    public static final int kXR_nocrc = 0;
    public static final int kXR_crc32 = 1;
    public static final byte kXR_useruser = 0;
    public static final byte kXR_useradmin = 1;
    public static final int kXR_cancel = 1;
    public static final int kXR_notify = 2;
    public static final int kXR_noerrs = 4;
    public static final int kXR_stage = 8;
    public static final int kXR_wmode = 16;
    public static final int kXR_coloc = 32;
    public static final int kXR_fresh = 64;
    public static final int kXR_usetcp = 128;
    public static final int kXR_evict = 1;
    public static final int kXR_ok = 0;
    public static final int kXR_oksofar = 4000;
    public static final int kXR_attn = 4001;
    public static final int kXR_authmore = 4002;
    public static final int kXR_error = 4003;
    public static final int kXR_redirect = 4004;
    public static final int kXR_wait = 4005;
    public static final int kXR_waitresp = 4006;
    public static final int kXR_noResponsesYet = 10000;
    public static final int kXR_asyncab = 5000;
    public static final int kXR_asyncdi = 5001;
    public static final int kXR_asyncms = 5002;
    public static final int kXR_asyncrd = 5003;
    public static final int kXR_asyncwt = 5004;
    public static final int kXR_asyncav = 5005;
    public static final int kXR_asynunav = 5006;
    public static final int kXR_asyncgo = 5007;
    public static final int kXR_asynresp = 5008;
    public static final int kXR_asyninfo = 5009;
    public static final int kXR_ArgInvalid = 3000;
    public static final int kXR_ArgMissing = 3001;
    public static final int kXR_ArgTooLong = 3002;
    public static final int kXR_FileLocked = 3003;
    public static final int kXR_FileNotOpen = 3004;
    public static final int kXR_FSError = 3005;
    public static final int kXR_InvalidRequest = 3006;
    public static final int kXR_IOError = 3007;
    public static final int kXR_NoMemory = 3008;
    public static final int kXR_NoSpace = 3009;
    public static final int kXR_NotAuthorized = 3010;
    public static final int kXR_NotFound = 3011;
    public static final int kXR_ServerError = 3012;
    public static final int kXR_Unsupported = 3013;
    public static final int kXR_noserver = 3014;
    public static final int kXR_NotFile = 3015;
    public static final int kXR_isDirectory = 3016;
    public static final int kXR_Cancelled = 3017;
    public static final int kXR_ChkLenErr = 3018;
    public static final int kXR_ChkSumErr = 3019;
    public static final int kXR_inProgress = 3020;
    public static final int kXR_overQuota = 3021;
    public static final int kXR_SigVerErr = 3022;
    public static final int kXR_DecryptErr = 3023;
    public static final int kXR_Overloaded = 3024;
    public static final int kXR_fsReadOnly = 3025;
    public static final int kXR_BadPayload = 3026;
    public static final int kXR_AttrNotFound = 3027;
    public static final int kXR_TLSRequired = 3028;
    public static final int kXR_noReplicas = 3029;
    public static final int kXR_ERRFENCE = 3030;
    public static final int kXR_noErrorYet = 10000;
    @Deprecated
    public static final int kXR_FileLockedr = 3003;

    public static String getClientRequest(int code) {
        switch (code) {
            case 0: {
                return "kXR_handshake";
            }
            case 3000: {
                return "kXR_auth";
            }
            case 3001: {
                return "kXR_query";
            }
            case 3002: {
                return "kXR_chmod";
            }
            case 3003: {
                return "kXR_close";
            }
            case 3004: {
                return "kXR_dirlist";
            }
            case 3005: {
                return "kXR_gpfile";
            }
            case 3006: {
                return "kXR_protocol";
            }
            case 3007: {
                return "kXR_login";
            }
            case 3008: {
                return "kXR_mkdir";
            }
            case 3009: {
                return "kXR_mv";
            }
            case 3010: {
                return "kXR_open";
            }
            case 3011: {
                return "kXR_ping";
            }
            case 3012: {
                return "kXR_chkpoint";
            }
            case 3013: {
                return "kXR_read";
            }
            case 3014: {
                return "kXR_rm";
            }
            case 3015: {
                return "kXR_rmdir";
            }
            case 3016: {
                return "kXR_sync";
            }
            case 3017: {
                return "kXR_stat";
            }
            case 3018: {
                return "kXR_set";
            }
            case 3019: {
                return "kXR_write";
            }
            case 3020: {
                return "kXR_fattr";
            }
            case 3021: {
                return "kXR_prepare";
            }
            case 3022: {
                return "kXR_statx";
            }
            case 3023: {
                return "kXR_endsess";
            }
            case 3024: {
                return "kXR_bind";
            }
            case 3025: {
                return "kXR_readv";
            }
            case 3026: {
                return "kXR_pgwrite";
            }
            case 3027: {
                return "kXR_locate";
            }
            case 3028: {
                return "kXR_truncate";
            }
            case 3029: {
                return "kXR_sigver";
            }
            case 3030: {
                return "kXR_pgread";
            }
            case 3031: {
                return "kXR_writev";
            }
            case 3032: {
                return "kXR_REQFENCE";
            }
        }
        return "unrecognized client request";
    }

    public static String getServerError(int code) {
        switch (code) {
            case 3000: {
                return "kXR_ArgInvalid";
            }
            case 3001: {
                return "kXR_ArgMissing";
            }
            case 3002: {
                return "kXR_ArgTooLong";
            }
            case 3003: {
                return "kXR_FileLocked";
            }
            case 3004: {
                return "kXR_FileNotOpen";
            }
            case 3005: {
                return "kXR_FSError";
            }
            case 3006: {
                return "kXR_InvalidRequest";
            }
            case 3007: {
                return "kXR_IOError";
            }
            case 3008: {
                return "kXR_NoMemory";
            }
            case 3009: {
                return "kXR_NoSpace";
            }
            case 3010: {
                return "kXR_NotAuthorized";
            }
            case 3011: {
                return "kXR_NotFound";
            }
            case 3012: {
                return "kXR_ServerError";
            }
            case 3013: {
                return "kXR_Unsupported";
            }
            case 3014: {
                return "kXR_noserver";
            }
            case 3015: {
                return "kXR_NotFile";
            }
            case 3016: {
                return "kXR_isDirectory";
            }
            case 3017: {
                return "kXR_Cancelled";
            }
            case 3018: {
                return "kXR_ChkLenErr";
            }
            case 3019: {
                return "kXR_ChkSumErr";
            }
            case 3020: {
                return "kXR_inProgress";
            }
            case 3021: {
                return "kXR_overQuota";
            }
            case 3022: {
                return "kXR_SigVerErr";
            }
            case 3023: {
                return "kXR_DecryptErr";
            }
            case 3024: {
                return "kXR_Overloaded";
            }
            case 3025: {
                return "kXR_fsReadOnly";
            }
            case 3026: {
                return "kXR_BadPayload";
            }
            case 3027: {
                return "kXR_AttrNotFound";
            }
            case 3028: {
                return "kXR_TLSRequired";
            }
            case 3029: {
                return "kXR_noReplicas";
            }
            case 3030: {
                return "kXR_ERRFENCE";
            }
            case 10000: {
                return "kXR_noErrorYet";
            }
        }
        return "unrecognized server error";
    }

    public static enum FilePerm {
        READ("read"),
        WRITE_ONCE("write-once"),
        WRITE("write"),
        DELETE("delete");

        private final String _xmlText;

        private FilePerm(String xmlText) {
            this._xmlText = xmlText;
        }

        public String xmlText() {
            return this._xmlText;
        }
    }
}

