/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;
import org.dcache.xrootd.security.UnsignedIntBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRequest
extends AbstractXrootdRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRequest.class);
    private final String protocol;
    private final int step;
    private Integer version;
    private final Map<XrootdSecurityProtocol.BucketType, XrootdBucket> bucketMap = new EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket>(XrootdSecurityProtocol.BucketType.class);

    public AuthenticationRequest(ByteBuf buffer) {
        super(buffer, 3000);
        buffer.readerIndex(24);
        this.protocol = AuthenticationRequest.deserializeProtocol(buffer);
        if (this.protocol.equals("unix")) {
            this.step = 0;
            return;
        }
        this.step = AuthenticationRequest.deserializeStep(buffer);
        try {
            this.bucketMap.putAll(AuthenticationRequest.deserializeBuckets(buffer));
        }
        catch (IOException ioex) {
            throw new IllegalArgumentException("Illegal credential format: {}", ioex);
        }
        UnsignedIntBucket versionBucket = (UnsignedIntBucket)this.bucketMap.get((Object)XrootdSecurityProtocol.BucketType.kXRS_version);
        if (versionBucket != null) {
            this.version = versionBucket.getContent();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.describe());
        }
    }

    public String describe() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("/////////////////////////////////////////////////////////\n");
        builder.append("//                Authentication Request\n");
        builder.append("//\n");
        builder.append("//  stream:  ").append(this.streamId).append("\n");
        builder.append("//  request: ").append(this.requestId).append("\n");
        builder.append("//\n");
        int i = 0;
        Collection<XrootdBucket> buckets = this.bucketMap.values();
        for (XrootdBucket bucket : buckets) {
            ++i;
            i = bucket.dump(builder, XrootdSecurityProtocol.getClientStep(this.step), i);
        }
        builder.append("/////////////////////////////////////////////////////////\n");
        return builder.toString();
    }

    public static Map<XrootdSecurityProtocol.BucketType, XrootdBucket> deserializeBuckets(ByteBuf buffer) throws IOException {
        int bucketCode = buffer.readInt();
        XrootdSecurityProtocol.BucketType bucketType = XrootdSecurityProtocol.BucketType.get(bucketCode);
        EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket> buckets = new EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket>(XrootdSecurityProtocol.BucketType.class);
        while (bucketType != XrootdSecurityProtocol.BucketType.kXRS_none) {
            int bucketLength = buffer.readInt();
            XrootdBucket bucket = XrootdBucket.deserialize(bucketType, buffer.slice(buffer.readerIndex(), bucketLength));
            buckets.put(bucketType, bucket);
            LOGGER.debug("Deserialized a bucket with code {}, type {}", (Object)bucketCode, (Object)bucketType);
            buffer.readerIndex(buffer.readerIndex() + bucketLength);
            bucketCode = buffer.readInt();
            bucketType = XrootdSecurityProtocol.BucketType.get(bucketCode);
        }
        return buckets;
    }

    public static String deserializeProtocol(ByteBuf buffer) {
        String protocol = buffer.toString(buffer.readerIndex(), 4, StandardCharsets.US_ASCII).trim();
        buffer.readerIndex(buffer.readerIndex() + 4);
        return protocol;
    }

    public static int deserializeStep(ByteBuf buffer) {
        return buffer.readInt();
    }

    public Map<XrootdSecurityProtocol.BucketType, XrootdBucket> getBuckets() {
        return this.bucketMap;
    }

    public int getStep() {
        return this.step;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Integer getVersion() {
        return this.version;
    }
}

