/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.LoginRequest;

public class LoginResponse
extends AbstractXrootdResponse<LoginRequest> {
    private final XrootdSessionIdentifier sessionId;
    private final String sec;

    public LoginResponse(LoginRequest request, XrootdSessionIdentifier sessionId, String sec) {
        super(request, 0);
        this.sessionId = sessionId;
        this.sec = sec;
    }

    public XrootdSessionIdentifier getSessionId() {
        return this.sessionId;
    }

    public String getSec() {
        return this.sec;
    }

    @Override
    public int getDataLength() {
        return 16 + (this.sec.isEmpty() ? 0 : this.sec.length() + 1);
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeBytes(this.sessionId.getBytes());
        if (!this.sec.isEmpty()) {
            buffer.writeBytes(this.sec.getBytes(StandardCharsets.US_ASCII));
            buffer.writeByte(0);
        }
    }

    public String toString() {
        return "login-response[" + this.sessionId + "," + this.sec + "]";
    }
}

