/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class RawBucket
extends XrootdBucket {
    private static final String[] BYTE_DUMP = new String[]{"//  0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x    %s\n", "//  0x%02x                                                     %s\n", "//  0x%02x 0x%02x                                              %s\n", "//  0x%02x 0x%02x 0x%02x                                       %s\n", "//  0x%02x 0x%02x 0x%02x 0x%02x                                %s\n", "//  0x%02x 0x%02x 0x%02x 0x%02x 0x%02x                         %s\n", "//  0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x                  %s\n", "//  0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x           %s\n"};
    private final byte[] _data;

    public static void dumpBytes(StringBuilder builder, byte[] data) {
        int i = 0;
        int D = data.length / 8;
        for (int d = 0; d < D; ++d) {
            builder.append(String.format(BYTE_DUMP[0], data[i], data[i + 1], data[i + 2], data[i + 3], data[i + 4], data[i + 5], data[i + 6], data[i + 7], RawBucket.getAscii(data, i, 8)));
            i += 8;
        }
        switch (data.length % 8) {
            case 7: {
                builder.append(String.format(BYTE_DUMP[7], data[i], data[i + 1], data[i + 2], data[i + 3], data[i + 4], data[i + 5], data[i + 6], RawBucket.getAscii(data, i, 7)));
                break;
            }
            case 6: {
                builder.append(String.format(BYTE_DUMP[6], data[i], data[i + 1], data[i + 2], data[i + 3], data[i + 4], data[i + 5], RawBucket.getAscii(data, i, 6)));
                break;
            }
            case 5: {
                builder.append(String.format(BYTE_DUMP[5], data[i], data[i + 1], data[i + 2], data[i + 3], data[i + 4], RawBucket.getAscii(data, i, 5)));
                break;
            }
            case 4: {
                builder.append(String.format(BYTE_DUMP[4], data[i], data[i + 1], data[i + 2], data[i + 3], RawBucket.getAscii(data, i, 4)));
                break;
            }
            case 3: {
                builder.append(String.format(BYTE_DUMP[3], data[i], data[i + 1], data[i + 2], RawBucket.getAscii(data, i, 3)));
                break;
            }
            case 2: {
                builder.append(String.format(BYTE_DUMP[2], data[i], data[i + 1], RawBucket.getAscii(data, i, 2)));
                break;
            }
            case 1: {
                builder.append(String.format(BYTE_DUMP[1], data[i], RawBucket.getAscii(data, i, 1)));
            }
        }
    }

    private static String getAscii(byte[] bytes, int from, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = bytes[from + i];
            if (32 < b && b < 127) {
                sb.append((char)b);
                continue;
            }
            sb.append('.');
        }
        return sb.toString();
    }

    public RawBucket(XrootdSecurityProtocol.BucketType type, byte[] data) {
        super(type);
        this._data = data;
    }

    @Override
    public int dump(StringBuilder builder, String step, int number) {
        super.dump(builder, step, number);
        builder.append("//\n");
        builder.append("//                  RAW BYTE CONTENTS                  //\n");
        builder.append("//\n");
        RawBucket.dumpBytes(builder, this._data);
        return number;
    }

    public byte[] getContent() {
        return this._data;
    }

    public static RawBucket deserialize(XrootdSecurityProtocol.BucketType type, ByteBuf buffer) {
        byte[] tmp = new byte[buffer.readableBytes()];
        buffer.getBytes(0, tmp);
        return new RawBucket(type, tmp);
    }

    @Override
    public void serialize(ByteBuf out) {
        super.serialize(out);
        out.writeInt(this._data.length);
        out.writeBytes(this._data);
    }

    @Override
    public int getSize() {
        return super.getSize() + 4 + this._data.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " hex dump:");
        for (byte b : this._data) {
            sb.append(" ").append(Integer.toHexString(b));
        }
        return sb.toString();
    }
}

