/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.tpc.protocol.messages.InboundRedirectResponse;
import org.dcache.xrootd.util.FileStatus;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;

public class XrootdTpcInfo {
    public static final String STAGE = "tpc.stage";
    public static final String RENDEZVOUS_KEY = "tpc.key";
    public static final String SRC = "tpc.src";
    public static final String DLG = "tpc.dlg";
    public static final String DLGON = "tpc.dlgon";
    public static final String DST = "tpc.dst";
    public static final String LOGICAL_NAME = "tpc.lfn";
    public static final String CLIENT = "tpc.org";
    public static final String CHECKSUM = "tpc.cks";
    public static final String TIME_TO_LIVE = "tpc.ttl";
    public static final String SIZE_IN_BYTES = "oss.asize";
    public static final String STR = "tpc.str";
    public static final String TPR = "tpc.tpr";
    public static final String SPR = "tpc.spr";
    public static final String SCGI = "tpc.scgi";
    public static final String PLACEMENT = "placement";
    public static final String COPY = "copy";
    public static final String ADLER32 = "adler32";
    public static final String CRC32 = "crc32";
    public static final String MD5 = "md5";
    public static final String AUTHZ = "authz";
    private static final Set<String> TPC_KEYS = ImmutableSet.of((Object)"tpc.stage", (Object)"tpc.key", (Object)"tpc.src", (Object)"tpc.dst", (Object)"tpc.lfn", (Object)"tpc.org", (Object[])new String[]{"tpc.cks", "tpc.ttl", "oss.asize", "tpc.str", "tpc.dlg", "tpc.dlgon", "tpc.tpr", "tpc.spr", "tpc.scgi", "authz"});
    private final String key;
    private final long createdTime;
    private Delegation dlgon;
    private String org;
    private String dst;
    private String src;
    private String srcHost;
    private Integer srcPort;
    private String lfn;
    private Long ttl;
    private String cks;
    private Long asize;
    private Status status;
    private int fd;
    private long startTime;
    private Boolean tls;
    private String external;
    private String loginToken;
    private String sourceToken;
    private FileStatus fileStatus;
    private Serializable delegatedProxy;
    private OptionalLong fileSize = OptionalLong.empty();

    public XrootdTpcInfo(String key) {
        this.key = key;
        this.createdTime = System.currentTimeMillis();
    }

    public XrootdTpcInfo(Map<String, String> opaque) throws ParseException {
        this(opaque.get(RENDEZVOUS_KEY));
        this.dlgon = Delegation.valueOf(opaque);
        this.lfn = opaque.get(LOGICAL_NAME);
        this.dst = opaque.get(DST);
        this.setSourceFromOpaque(opaque);
        this.cks = opaque.get(CHECKSUM);
        this.setTlsFromOpaque(opaque);
        String asize = opaque.get(SIZE_IN_BYTES);
        if (asize != null) {
            this.asize = Long.parseLong(asize);
        }
        this.status = Status.READY;
        this.findSourceToken(opaque);
        this.addExternal(opaque);
    }

    public synchronized XrootdTpcInfo addInfoFromOpaque(String slfn, Map<String, String> opaque) throws ParseException {
        String value;
        if (this.lfn == null) {
            this.lfn = slfn;
        }
        this.dlgon = Delegation.valueOf(opaque);
        if (this.org == null) {
            this.org = opaque.get(CLIENT);
        }
        if (this.dst == null) {
            this.dst = opaque.get(DST);
        }
        if (this.src == null) {
            this.setSourceFromOpaque(opaque);
        }
        if (this.cks == null) {
            this.cks = opaque.get(CHECKSUM);
        }
        if (this.tls == null) {
            this.setTlsFromOpaque(opaque);
        }
        if ((value = opaque.get(TIME_TO_LIVE)) != null) {
            this.ttl = new Long(value);
            this.startTime = System.currentTimeMillis();
        }
        if ((value = opaque.get(SIZE_IN_BYTES)) != null) {
            this.asize = Long.parseLong(value);
        }
        if (this.status == null) {
            this.status = Status.PENDING;
        } else if (this.status == Status.PENDING) {
            this.status = Status.READY;
        }
        if (this.sourceToken == null) {
            this.findSourceToken(opaque);
        }
        this.addExternal(opaque);
        return this;
    }

    public long computeFileSize() throws XrootdException {
        if (!this.fileSize.isPresent()) {
            if (this.fileStatus == null) {
                if (this.asize == null) {
                    throw new XrootdException(3001, "Cannot read source; file size is unknown.");
                }
                this.fileSize = OptionalLong.of(this.asize);
            } else {
                this.fileSize = OptionalLong.of(this.fileStatus.getSize());
            }
        }
        return this.fileSize.getAsLong();
    }

    public XrootdTpcInfo copyForRedirect(InboundRedirectResponse response) throws ParseException {
        XrootdTpcInfo info = new XrootdTpcInfo(this.key);
        URL url = response.getUrl();
        if (url != null) {
            info.srcHost = url.getHost();
            info.srcPort = url.getPort();
        } else {
            info.srcHost = response.getHost();
            info.srcPort = response.getPort();
        }
        info.src = info.srcHost + ":" + info.srcPort;
        info.dlgon = this.dlgon;
        info.lfn = this.lfn;
        info.asize = this.asize;
        info.cks = this.cks;
        info.tls = this.tls;
        info.loginToken = response.getToken();
        info.delegatedProxy = this.delegatedProxy;
        String opaque = response.getOpaque();
        if (opaque == null && url != null) {
            opaque = url.getQuery();
        }
        if (opaque != null) {
            if (!opaque.startsWith("?")) {
                opaque = "?" + opaque;
            }
            Map<String, String> map = OpaqueStringParser.getOpaqueMap(opaque);
            info.sourceToken = map.get(AUTHZ);
            info.addExternal(map);
        }
        info.status = Status.READY;
        return info;
    }

    public boolean isTls() {
        return this.tls;
    }

    public synchronized Status verify(String dst, String slfn, String org) {
        if (this.status == Status.ERROR) {
            return this.status;
        }
        if (this.dst == null) {
            return Status.PENDING;
        }
        this.status = dst.equals(this.dst) && slfn.equals(this.lfn) && org.equals(this.org) && !this.isExpired() ? Status.READY : Status.CANCELLED;
        return this.status;
    }

    public String toString() {
        return "(key " + this.key + ")(dlgon " + (Object)((Object)this.dlgon) + ")(dst " + this.dst + ")(src " + this.srcHost + ":" + this.srcPort + ")(org " + this.org + ")(lfn " + this.lfn + ")(ttl " + this.ttl + ")(cks " + this.cks + ")(asize " + this.asize + ")(fhandle " + this.fd + ")(tls " + this.tls + ")(status " + (Object)((Object)this.status) + ")(token " + this.loginToken + ")(source token " + this.sourceToken + ")(external [" + this.external + "])";
    }

    public boolean isExpired() {
        return this.ttl != null && System.currentTimeMillis() > this.startTime + TimeUnit.SECONDS.toMillis(this.ttl);
    }

    public String getCks() {
        return this.cks;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public Serializable getDelegatedProxy() {
        return this.delegatedProxy;
    }

    public Delegation getDlgon() {
        return this.dlgon;
    }

    public String getSourceToken() {
        return this.sourceToken;
    }

    public String getExternal() {
        return this.external;
    }

    public String getDst() {
        return this.dst;
    }

    public int getFd() {
        return this.fd;
    }

    public String getKey() {
        return this.key;
    }

    public String getLfn() {
        return this.lfn;
    }

    public String getLoginToken() {
        return this.loginToken;
    }

    public String getOrg() {
        return this.org;
    }

    public String getSrc() {
        return this.src;
    }

    public String getSrcHost() {
        return this.srcHost;
    }

    public Integer getSrcPort() {
        return this.srcPort;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setAsize(long asize) {
        this.asize = asize;
    }

    public void setCks(String cks) {
        this.cks = cks;
    }

    public void setDelegatedProxy(Serializable delegatedProxy) {
        this.delegatedProxy = delegatedProxy;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setFileStatus(FileStatus fileStatus) {
        this.fileStatus = fileStatus;
    }

    public void setFd(int fd) {
        this.fd = fd;
    }

    public void setLfn(String lfn) {
        this.lfn = lfn;
    }

    public void setLoginToken(String loginToken) {
        this.loginToken = loginToken;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setSrcHost(String srcHost) {
        this.srcHost = srcHost;
    }

    public void setSrcPort(Integer srcPort) {
        this.srcPort = srcPort;
    }

    public synchronized void setStatus(Status status) {
        this.status = status;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    private void addExternal(Map<String, String> opaque) {
        HashMap<String, String> external = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : opaque.entrySet()) {
            if (TPC_KEYS.contains(entry.getKey())) continue;
            external.put(entry.getKey(), entry.getValue());
        }
        this.external = OpaqueStringParser.buildOpaqueString(external);
    }

    private void setSourceFromOpaque(Map<String, String> map) {
        this.src = map.get(DLG);
        if (this.src == null) {
            this.src = map.get(SRC);
        }
        if (this.src != null) {
            int at = this.src.indexOf("@");
            if (at >= 0) {
                this.src = this.src.substring(at + 1);
            }
            String[] source = this.src.split(":");
            this.srcHost = source[0];
            this.srcPort = source.length > 1 && Strings.emptyToNull((String)source[1]) != null ? Integer.valueOf(Integer.parseInt(source[1])) : Integer.valueOf(1094);
        }
    }

    private void setTlsFromOpaque(Map<String, String> map) {
        String tlsString = map.get(SPR);
        this.tls = "xroots".equals(tlsString);
    }

    private void findSourceToken(Map<String, String> opaque) throws ParseException {
        String scgi = opaque.get(SCGI);
        if (scgi != null) {
            scgi = scgi.replaceAll("\\t+", String.valueOf('&'));
            Map<String, String> sourceOpaque = OpaqueStringParser.getOpaqueMap(scgi);
            this.sourceToken = sourceOpaque.get(AUTHZ);
        }
    }

    static enum Delegation {
        OFF,
        ON;


        public static Delegation valueOf(Map<String, String> opaque) {
            String value = opaque.get(XrootdTpcInfo.DLGON);
            if (value == null) {
                return OFF;
            }
            switch (opaque.get(XrootdTpcInfo.DLGON)) {
                case "1": {
                    return ON;
                }
            }
            return OFF;
        }
    }

    public static enum Status {
        PENDING,
        READY,
        CANCELLED,
        ERROR;

    }
}

