/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import com.google.common.base.Splitter;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.security.SecurityInfo;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;

public class InboundLoginResponse
extends AbstractXrootdInboundResponse {
    private static final String PROTOCOL_PREFIX = "P=";
    private final XrootdSessionIdentifier sessionId;
    private final List<SecurityInfo> protocols;
    private final Map<String, SecurityInfo> protocolMap;

    public InboundLoginResponse(ByteBuf buffer) throws XrootdException {
        super(buffer);
        if (buffer.readableBytes() > 8) {
            int slen = buffer.getInt(4) - 16;
            byte[] session = new byte[16];
            buffer.getBytes(8, session);
            this.sessionId = new XrootdSessionIdentifier(session);
            if (slen > 0) {
                this.protocols = new ArrayList<SecurityInfo>();
                String sec = buffer.toString(24, slen, StandardCharsets.US_ASCII);
                for (String description : Splitter.on((char)'&').trimResults().omitEmptyStrings().split((CharSequence)sec)) {
                    if (!description.startsWith(PROTOCOL_PREFIX)) {
                        throw new XrootdException(4003, "Malformed 'sec': " + sec);
                    }
                    this.protocols.add(new SecurityInfo(description.substring(PROTOCOL_PREFIX.length())));
                }
            } else {
                this.protocols = Collections.EMPTY_LIST;
            }
        } else {
            this.sessionId = null;
            this.protocols = Collections.EMPTY_LIST;
        }
        this.protocolMap = this.protocols.stream().collect(Collectors.toMap(p -> p.getProtocol(), p -> p));
    }

    public List<SecurityInfo> getProtocols() {
        return this.protocols;
    }

    public SecurityInfo getInfo(String protocol) {
        return this.protocolMap.get(protocol);
    }

    public XrootdSessionIdentifier getSessionId() {
        return this.sessionId;
    }

    @Override
    public int getRequestId() {
        return 3007;
    }
}

