/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundRedirectResponse
extends AbstractXrootdInboundResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(InboundRedirectResponse.class);
    private final int requestId;
    private int port;
    private String host;
    private String opaque;
    private String token;
    private URL url;
    private int wsec;
    private int msec;

    public InboundRedirectResponse(InboundAttnResponse attnResponse) throws ParseException {
        super(attnResponse.streamId, attnResponse.stat);
        this.requestId = attnResponse.getRequestId();
        switch (attnResponse.getActnum()) {
            case 5001: {
                this.wsec = attnResponse.getWsec();
                this.msec = attnResponse.getMsec();
                break;
            }
            case 5003: {
                this.port = attnResponse.getPort();
                this.parseRedirectString(attnResponse.getRedirectData());
                this.token = this.opaque;
                this.opaque = null;
                this.wsec = 0;
                this.msec = 0;
            }
        }
    }

    public InboundRedirectResponse(ByteBuf buffer, int requestId) throws ParseException {
        super(buffer);
        this.requestId = requestId;
        int len = buffer.getInt(4);
        this.port = buffer.getInt(8);
        this.parseRedirectString(buffer.toString(12, len - 4, StandardCharsets.US_ASCII));
        this.wsec = 0;
        this.msec = 0;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    public String getHost() {
        return this.host;
    }

    public int getMsec() {
        return this.msec;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public int getPort() {
        return this.port;
    }

    public String getToken() {
        return this.token;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getWsec() {
        return this.wsec;
    }

    public boolean isReconnect() {
        return this.host == null && this.url == null;
    }

    public String toString() {
        return String.format("[kXR_redirect (host %s)(port %d)(opaque %s)(token %s)(url %s)]", this.host, this.port, this.opaque, this.token, this.url);
    }

    private void parseRedirectString(String redirect) throws ParseException {
        if (this.port == -1) {
            try {
                this.url = new URL(redirect);
            }
            catch (MalformedURLException e) {
                throw new ParseException("redirect : " + e.getMessage());
            }
        } else {
            int index = redirect.indexOf("?");
            if (index == -1) {
                this.host = redirect;
            } else {
                this.host = redirect.substring(0, index);
                redirect = redirect.substring(index);
                while (redirect.startsWith("?")) {
                    redirect = redirect.substring(1);
                }
                if (redirect.contains("=")) {
                    String[] parts = redirect.split("[?]");
                    this.opaque = parts[0];
                    if (parts.length > 1) {
                        this.token = parts[1];
                    }
                } else {
                    this.opaque = "";
                    this.token = redirect;
                }
            }
        }
    }
}

