/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;

public class OutboundLoginRequest
extends AbstractXrootdOutboundRequest {
    private final String username;
    private final int pid;
    private final String token;

    public OutboundLoginRequest(int streamId, int pid, String username, String token) {
        super(streamId, 3007);
        this.pid = pid;
        this.username = username;
        this.token = token;
    }

    @Override
    protected void getParams(ByteBuf buffer) {
        buffer.writeInt(this.pid);
        OutboundLoginRequest.setPaddedUserName(this.username, buffer);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(4);
        buffer.writeByte(0);
        if (this.token != null) {
            buffer.writeInt(this.token.length());
            buffer.writeBytes(this.token.getBytes(StandardCharsets.US_ASCII));
        } else {
            buffer.writeInt(0);
        }
    }

    @Override
    protected int getParamsLen() {
        return 20 + (this.token == null ? 0 : this.token.length());
    }

    private static void setPaddedUserName(String name, ByteBuf buffer) {
        int len = name.length();
        byte[] ascii = name.getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < 8; ++i) {
            if (i < len) {
                buffer.writeByte((int)ascii[i]);
                continue;
            }
            buffer.writeByte(0);
        }
    }
}

