/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundChecksumResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundCloseResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundEndSessionResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundErrorResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundHandshakeResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundLoginResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundOpenReadOnlyResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundProtocolResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundReadResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundRedirectResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundWaitRespResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundWaitResponse;
import org.dcache.xrootd.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdClientDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdClientDecoder.class);
    protected final XrootdTpcClient client;
    protected final String sourceUrn;

    public XrootdClientDecoder(XrootdTpcClient client) {
        this.client = client;
        this.sourceUrn = client.getInfo().getSrc();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ChannelId id = ctx.channel().id();
        int readable = in.readableBytes();
        if (readable < 8) {
            return;
        }
        int pos = in.readerIndex();
        int headerFrameLength = in.getInt(pos + 4);
        if (headerFrameLength < 0) {
            LOGGER.error("Decoder {}, channel {}: received illegal frame length in xrootd header: {}. Closing channel.", new Object[]{this.sourceUrn, id, headerFrameLength});
            ctx.channel().close();
            return;
        }
        int length = 8 + headerFrameLength;
        if (readable < length) {
            return;
        }
        ByteBuf frame = in.readSlice(length);
        int requestId = this.client.getExpectedResponse();
        try {
            switch (frame.getUnsignedShort(2)) {
                case 4003: {
                    LOGGER.debug("Decoder {}, channel {}: adding error response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundErrorResponse(frame));
                    return;
                }
                case 4005: {
                    LOGGER.debug("Decoder {}, channel {}: adding wait response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundWaitResponse(frame, requestId));
                    return;
                }
                case 4006: {
                    LOGGER.debug("Decoder {}, channel {}: adding waitresp response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundWaitRespResponse(frame, requestId));
                    return;
                }
                case 4004: {
                    LOGGER.debug("Decoder {}, channel {}: adding redirect response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundRedirectResponse(frame, requestId));
                    return;
                }
                case 4001: {
                    LOGGER.debug("Decoder {}, channel {}: adding attn response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundAttnResponse(frame, requestId));
                    return;
                }
            }
            switch (requestId) {
                case 0: {
                    LOGGER.debug("Decoder {}, channel {}: adding handshake response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundHandshakeResponse(frame));
                    break;
                }
                case 3006: {
                    LOGGER.debug("Decoder {}, channel {}: adding protocol response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundProtocolResponse(frame));
                    break;
                }
                case 3007: {
                    LOGGER.debug("Decoder {}, channel {}: adding login response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundLoginResponse(frame));
                    break;
                }
                case 3000: {
                    LOGGER.debug("Decoder {}, channel {}: adding authentication response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundAuthenticationResponse(frame));
                    break;
                }
                case 3010: {
                    LOGGER.debug("Decoder {}, channel {}: adding open response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundOpenReadOnlyResponse(frame));
                    break;
                }
                case 3013: {
                    LOGGER.debug("Decoder {}, channel {}: adding read response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundReadResponse(frame));
                    break;
                }
                case 3001: {
                    LOGGER.debug("Decoder {}, channel {}: adding query response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundChecksumResponse(frame));
                    break;
                }
                case 3003: {
                    LOGGER.debug("Decoder {}, channel {}: adding close response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundCloseResponse(frame));
                    break;
                }
                case 3023: {
                    LOGGER.debug("Decoder {}, channel {}: adding endsess response.", (Object)this.sourceUrn, (Object)id);
                    out.add(new InboundEndSessionResponse(frame));
                    break;
                }
                default: {
                    LOGGER.debug("Decoder {}, channel {}, received incorrect response of request type {}.", new Object[]{this.sourceUrn, id, requestId});
                    throw new XrootdException(4003, "received incorrect response type.");
                }
            }
        }
        catch (XrootdException | ParseException e) {
            LOGGER.error("Decoder {}, channel {}: error for request type {}: {}. Closing channel.", new Object[]{requestId, id, e.getMessage()});
            this.client.setError(e);
            this.client.shutDown(ctx);
        }
    }
}

