/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;

public class InboundAuthenticationResponse
extends AbstractXrootdInboundResponse {
    private final int dataLength;
    private final ByteBuf data;

    public InboundAuthenticationResponse(ByteBuf buffer) throws XrootdException {
        super(buffer);
        buffer.readerIndex(4);
        this.dataLength = buffer.readInt();
        if (this.dataLength == 0) {
            this.data = null;
            return;
        }
        this.data = buffer.alloc().ioBuffer(this.dataLength);
        this.data.writeBytes(buffer);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public int getRequestId() {
        return 3000;
    }

    public ByteBuf getDataBuffer() {
        return this.data;
    }

    public void releaseBuffer() {
        if (this.data != null) {
            this.data.release();
        }
    }
}

