/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.util.ByteBuffersProvider;

public class InboundReadResponse
extends AbstractXrootdInboundResponse
implements ByteBuffersProvider {
    private final ByteBuf data;
    private final int dlen;
    private long writeOffset;

    public InboundReadResponse(ByteBuf buffer) {
        super(buffer);
        this.dlen = buffer.getInt(4);
        this.data = buffer.alloc().ioBuffer(this.dlen);
        buffer.getBytes(8, this.data);
    }

    public int getDlen() {
        return this.dlen;
    }

    @Override
    public int getRequestId() {
        return 3013;
    }

    @Override
    public long getWriteOffset() {
        return this.writeOffset;
    }

    public void setWriteOffset(long writeOffset) {
        this.writeOffset = writeOffset;
    }

    @Override
    public ByteBuffer[] toByteBuffers() {
        return (this.data.nioBufferCount() == -1 ? this.data.copy() : this.data).nioBuffers();
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public ReferenceCounted retain() {
        this.data.retain();
        return this;
    }

    public ReferenceCounted retain(int i) {
        this.data.retain(i);
        return this;
    }

    public ReferenceCounted touch() {
        this.data.touch();
        return this;
    }

    public ReferenceCounted touch(Object o) {
        this.data.touch(o);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int i) {
        return this.data.release(i);
    }
}

