/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.Arrays;
import java.util.List;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdHandshakeHandler
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdHandshakeHandler.class);
    private final byte[] response;

    public XrootdHandshakeHandler(int serverType) {
        switch (serverType) {
            case 0: {
                this.response = XrootdProtocol.HANDSHAKE_RESPONSE_LOADBALANCER;
                break;
            }
            case 1: {
                this.response = XrootdProtocol.HANDSHAKE_RESPONSE_DATASERVER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown server type: " + serverType);
            }
        }
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() >= 20) {
            byte[] handshake = new byte[20];
            in.readBytes(handshake);
            if (!Arrays.equals(handshake, XrootdProtocol.HANDSHAKE_REQUEST)) {
                in.clear();
                LOGGER.warn("{} Received invalid handshake.", (Object)ctx.channel());
                ctx.close();
                return;
            }
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.response));
            ctx.channel().pipeline().remove((ChannelHandler)this);
        }
    }
}

