/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.core.XrootdDecoder;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class AuthenticationRequest
extends AbstractXrootdRequest {
    private final String credType;
    private final int credLen;
    private final ByteBuf credential;

    public AuthenticationRequest(ByteBuf buffer) {
        super(buffer, 3000);
        buffer.readerIndex(16);
        this.credType = XrootdDecoder.readAscii(buffer, 4);
        this.credLen = buffer.readInt();
        if (this.credLen == 0) {
            this.credential = null;
            return;
        }
        this.credential = buffer.alloc().ioBuffer(this.credLen);
        this.credential.writeBytes(buffer);
    }

    public String getCredType() {
        return this.credType;
    }

    public int getCredLen() {
        return this.credLen;
    }

    public ByteBuf getCredentialBuffer() {
        return this.credential;
    }

    public void releaseBuffer() {
        if (this.credential != null) {
            this.credential.release();
        }
    }
}

